/*
 * Decompiled with CFR 0.152.
 */
package realdrops.handlers;

import java.util.ArrayDeque;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import realdrops.core.RID_Settings;
import realdrops.entities.EntityItemLoot;
import realdrops.handlers.ConfigHandler;
import realdrops.utils.AuxUtilities;

public class EventHandler {
    private final ArrayDeque<PendingItem> itemQueue = new ArrayDeque();

    @SubscribeEvent
    public void onPlayerClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        Entity entity;
        if (event.getWorld().field_72995_K || RID_Settings.autoPickup) {
            return;
        }
        RayTraceResult mop = AuxUtilities.RayCastEntity((EntityLivingBase)event.getEntityPlayer(), RID_Settings.reach);
        Entity entity2 = entity = mop == null ? null : mop.field_72308_g;
        if (entity instanceof EntityItemLoot) {
            if (!event.getWorld().field_72995_K) {
                ((EntityItemLoot)entity).pickup(event.getEntityPlayer());
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Entity entity;
        if (event.getWorld().field_72995_K || RID_Settings.autoPickup) {
            return;
        }
        RayTraceResult mop = AuxUtilities.RayCastEntity((EntityLivingBase)event.getEntityPlayer(), RID_Settings.reach);
        Entity entity2 = entity = mop == null ? null : mop.field_72308_g;
        if (entity instanceof EntityItemLoot) {
            if (!event.getWorld().field_72995_K) {
                ((EntityItemLoot)entity).pickup(event.getEntityPlayer());
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerClickItem(PlayerInteractEvent.RightClickItem event) {
        Entity entity;
        if (event.getWorld().field_72995_K || RID_Settings.autoPickup) {
            return;
        }
        RayTraceResult mop = AuxUtilities.RayCastEntity((EntityLivingBase)event.getEntityPlayer(), RID_Settings.reach);
        Entity entity2 = entity = mop == null ? null : mop.field_72308_g;
        if (entity instanceof EntityItemLoot) {
            if (!event.getWorld().field_72995_K) {
                ((EntityItemLoot)entity).pickup(event.getEntityPlayer());
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoin(EntityJoinWorldEvent event) {
        EntityItem item;
        if (event.getWorld().field_72995_K || event.isCanceled() || event.getEntity().field_70128_L) {
            return;
        }
        if (event.getEntity().getClass() == EntityItem.class && !(item = (EntityItem)event.getEntity()).func_92059_d().func_190926_b()) {
            this.itemQueue.add(new PendingItem(item, new EntityItemLoot(item)));
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        while (!this.itemQueue.isEmpty()) {
            PendingItem pend = this.itemQueue.poll();
            if (pend == null || ((PendingItem)pend).item.field_70128_L || pend.item.func_92059_d().func_190926_b()) continue;
            pend.item.func_70106_y();
            pend.item.func_92058_a(ItemStack.field_190927_a);
            pend.item.func_174871_r();
            ((PendingItem)pend).item.field_70170_p.func_72838_d((Entity)pend.loot);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K || event.getWorld().func_73046_m() != null && event.getWorld().func_73046_m().func_71278_l()) {
            return;
        }
        this.itemQueue.clear();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("realdrops")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    private class PendingItem {
        private final EntityItem item;
        private final EntityItemLoot loot;

        private PendingItem(EntityItem item, EntityItemLoot loot) {
            this.item = item;
            this.loot = loot;
        }
    }
}

