/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.util;

import com.theprogrammingturkey.gobblecore.util.GameUtil;
import com.theprogrammingturkey.gobblecore.util.Scheduler;
import com.theprogrammingturkey.gobblecore.util.Task;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MessageUtil {
    public static void sendMessageToPlayer(EntityPlayer player, String message) {
        if (player != null && GameUtil.isPlayerOnline(player)) {
            player.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static void sendMessageToPlayer(final EntityPlayer player, final String message, int delay) {
        Scheduler.scheduleTask(new Task("Delayed_Message", delay){

            @Override
            public void callback() {
                MessageUtil.sendMessageToPlayer(player, message);
            }
        });
    }

    public static void sendMessageToNearestPlayer(World world, BlockPos pos, String message) {
        EntityPlayer nearest = null;
        double nearestDist = 2.147483647E9;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist < nearestDist)) continue;
            nearestDist = dist;
            nearest = entityplayer;
        }
        if (nearest != null) {
            MessageUtil.sendMessageToPlayer(nearest, message);
        }
    }

    public static void sendMessageToNearestPlayerInRange(World world, BlockPos pos, int distance, String message) {
        EntityPlayer nearest = null;
        double nearestDist = 2.147483647E9;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist < nearestDist) || !(dist <= (double)distance)) continue;
            nearestDist = dist;
            nearest = entityplayer;
        }
        if (nearest != null) {
            MessageUtil.sendMessageToPlayer(nearest, message);
        }
    }

    public static void sendMessageToNearPlayers(World world, BlockPos pos, int distance, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist <= (double)distance)) continue;
            MessageUtil.sendMessageToPlayer(entityplayer, message);
        }
    }

    public static void sendMessageToAllPlayers(World world, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            MessageUtil.sendMessageToPlayer((EntityPlayer)world.field_73010_i.get(i), message);
        }
    }

    public void noPermision(EntityPlayer player, String action) {
        MessageUtil.sendMessageToPlayer(player, TextFormatting.RED + "You do not have permission to " + action + "!");
    }
}

