/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.items;

import com.theprogrammingturkey.gobblecore.IModCore;
import com.theprogrammingturkey.gobblecore.items.IItemHandler;
import com.theprogrammingturkey.gobblecore.items.ItemLoader;
import com.theprogrammingturkey.gobblecore.util.CustomEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemManager {
    private static Map<IModCore, CustomEntry<IItemHandler, ItemLoader>> itemHandlers = new HashMap<IModCore, CustomEntry<IItemHandler, ItemLoader>>();

    public static void registerItemHandler(IItemHandler handler, IModCore mod) {
        itemHandlers.put(mod, new CustomEntry<IItemHandler, ItemLoader>(handler, new ItemLoader(mod)));
    }

    @SubscribeEvent
    public void onItemRegistry(RegistryEvent.Register<Item> e) {
        for (IModCore mod : itemHandlers.keySet()) {
            Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get(mod.getModID()));
            CustomEntry<IItemHandler, ItemLoader> values = itemHandlers.get(mod);
            values.getValue().setItemRegistry((IForgeRegistry<Item>)e.getRegistry());
            values.getKey().registerItems(values.getValue());
        }
        Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get("gobblecore"));
    }

    public static void registerModels() {
        for (IModCore mod : itemHandlers.keySet()) {
            CustomEntry<IItemHandler, ItemLoader> values = itemHandlers.get(mod);
            values.getKey().registerModels(values.getValue());
        }
    }
}

