/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.blocks;

import com.theprogrammingturkey.gobblecore.IModCore;
import com.theprogrammingturkey.gobblecore.blocks.BlockLoader;
import com.theprogrammingturkey.gobblecore.blocks.IBlockHandler;
import com.theprogrammingturkey.gobblecore.util.CustomEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockManager {
    private static Map<IModCore, CustomEntry<IBlockHandler, BlockLoader>> blockHandlers = new HashMap<IModCore, CustomEntry<IBlockHandler, BlockLoader>>();

    public static void registerBlockHandler(IBlockHandler handler, IModCore mod) {
        blockHandlers.put(mod, new CustomEntry<IBlockHandler, BlockLoader>(handler, new BlockLoader(mod)));
    }

    @SubscribeEvent
    public void onBlockRegistry(RegistryEvent.Register<Block> e) {
        for (IModCore mod : blockHandlers.keySet()) {
            Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get(mod.getModID()));
            CustomEntry<IBlockHandler, BlockLoader> values = blockHandlers.get(mod);
            values.getValue().setBlockRegistry((IForgeRegistry<Block>)e.getRegistry());
            values.getKey().registerBlocks(values.getValue());
        }
        Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get("gobblecore"));
    }

    public static void registerModels() {
        for (IModCore mod : blockHandlers.keySet()) {
            CustomEntry<IBlockHandler, BlockLoader> values = blockHandlers.get(mod);
            values.getKey().registerModels(values.getValue());
        }
    }
}

