/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.theprogrammingturkey.gobblecore.IModCore;
import com.theprogrammingturkey.gobblecore.blocks.BlockManager;
import com.theprogrammingturkey.gobblecore.commands.CommandManager;
import com.theprogrammingturkey.gobblecore.config.ConfigLoader;
import com.theprogrammingturkey.gobblecore.config.GobbleCoreSettings;
import com.theprogrammingturkey.gobblecore.config.QueuedMessageReporter;
import com.theprogrammingturkey.gobblecore.entity.EntityManager;
import com.theprogrammingturkey.gobblecore.items.ItemManager;
import com.theprogrammingturkey.gobblecore.managers.WebHookManager;
import com.theprogrammingturkey.gobblecore.network.NetworkManager;
import com.theprogrammingturkey.gobblecore.proxy.IBaseProxy;
import com.theprogrammingturkey.gobblecore.proxy.ProxyManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandHandler;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="gobblecore", name="GobbleCore", version="1.12-0.1.6.35", guiFactory="com.theprogrammingturkey.gobblecore.client.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12]")
public class GobbleCore
implements IModCore {
    public static final String MODID = "gobblecore";
    public static final String NAME = "GobbleCore";
    public static final String VERSION = "1.12-0.1.6.35";
    public static final String GUIFACTORY = "com.theprogrammingturkey.gobblecore.client.gui.ConfigGuiFactory";
    @Mod.Instance(value="gobblecore")
    public static GobbleCore instance;
    @SidedProxy(clientSide="com.theprogrammingturkey.gobblecore.proxy.ClientProxy", serverSide="com.theprogrammingturkey.gobblecore.proxy.CommonProxy")
    public static IBaseProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigLoader.loadConfigSettings(event.getSuggestedConfigurationFile());
        ProxyManager.registerModProxy(proxy);
        EntityManager.registerEntities();
        NetworkManager.registerPackets();
        if (event.getSide() == Side.CLIENT) {
            EntityManager.registerRenderings();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            BlockManager.registerModels();
            ItemManager.registerModels();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (GobbleCoreSettings.allowWebServerConnect) {
            WebHookManager.registerHook(new WebHookManager.ModWebHook(this){

                @Override
                public void onResponse(JsonElement json) {
                    if (json.isJsonObject()) {
                        for (Map.Entry task : json.getAsJsonObject().entrySet()) {
                            if (!((String)task.getKey()).equals("ChatMessage")) continue;
                            for (JsonElement messageElement : ((JsonElement)task.getValue()).getAsJsonArray()) {
                                JsonObject messageData = messageElement.getAsJsonObject();
                                if (messageData.has("Username")) {
                                    if (!proxy.isClient() || !Minecraft.func_71410_x().func_110432_I().func_111285_a().equalsIgnoreCase(messageData.get("Username").getAsString())) continue;
                                    QueuedMessageReporter.queueMessage(TextFormatting.GREEN, GobbleCore.NAME, messageData.get("Message").getAsString());
                                    continue;
                                }
                                QueuedMessageReporter.queueMessage(TextFormatting.GREEN, GobbleCore.NAME, messageData.get("Message").getAsString());
                            }
                        }
                    }
                }
            });
            WebHookManager.processHooks();
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        CommandManager.loadCommandHandlers(event.getSide().isClient(), (CommandHandler)event.getServer().func_71187_D());
    }

    @Override
    public String getModID() {
        return MODID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }
}

