/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    public static void handleIMCMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            switch (message.key) {
                case "RegisterMarketCategory": {
                    NBTTagCompound tagCompound;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        tagCompound = message.getNBTValue();
                        ResourceLocation registryName = new ResourceLocation(tagCompound.func_74779_i("RegistryName"));
                        if (registryName.func_110624_b().equals(message.getSender())) {
                            String tooltipLangKey = tagCompound.func_150297_b("Tooltip", 8) ? tagCompound.func_74779_i("Tooltip") : "gui.farmingforblockheads:market.tooltip_none";
                            ResourceLocation texturePath = new ResourceLocation(tagCompound.func_74779_i("Texture"));
                            int textureX = tagCompound.func_74762_e("TextureX");
                            int textureY = tagCompound.func_74762_e("TextureY");
                            FarmingForBlockheadsAPI.registerMarketCategory(registryName, tooltipLangKey, texturePath, textureX, textureY);
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category must be prefixed by your mod id (from {})", (Object)message.getSender());
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketCategory expects NBT (from {})", (Object)message.getSender());
                    break;
                }
                case "RegisterMarketEntry": {
                    NBTTagCompound tagCompound;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        tagCompound = message.getNBTValue();
                        if (!tagCompound.func_150297_b("OutputItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires OutputItem tag (from {})", (Object)message.getSender());
                            break;
                        }
                        if (!tagCompound.func_150297_b("CostItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires CostItem tag (from {})", (Object)message.getSender());
                            break;
                        }
                        ItemStack outputItem = new ItemStack(tagCompound.func_74775_l("OutputItem"));
                        ItemStack costItem = new ItemStack(tagCompound.func_74775_l("CostItem"));
                        ResourceLocation categoryId = tagCompound.func_150297_b("Category", 8) ? new ResourceLocation(tagCompound.func_74779_i("Category")) : FarmingForBlockheadsAPI.MARKET_CATEGORY_OTHER;
                        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategory(categoryId);
                        if (category != null) {
                            FarmingForBlockheadsAPI.registerMarketEntry(outputItem, costItem, category);
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category {} does not exist (from {})", (Object)categoryId, (Object)message.getSender());
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)message.getSender());
                }
            }
        }
    }
}

