/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.monolith;

import java.util.UUID;
import net.darkhax.bookshelf.data.AttributeOperation;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.darkutils.features.monolith.TileEntityMonolith;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityMonolithSpawning
extends TileEntityMonolith {
    private static final AttributeModifier SPAWN_BONUS = new AttributeModifier(UUID.fromString("4d59c07e-abea-480c-a237-c9bafb5161e2"), "monolith_spawn_bonus", 0.2, AttributeOperation.MULTIPLY.ordinal());
    private int spawnCount = 0;
    private BlockPos down = null;

    @Override
    public void onEntityUpdate() {
        super.onEntityUpdate();
        if (this.down == null) {
            this.down = this.func_174877_v().func_177977_b();
        }
        if (this.func_145831_w() instanceof WorldServer) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                WorldUtils.attemptChunkSpawn((WorldServer)((WorldServer)this.func_145831_w()), (BlockPos)this.field_174879_c, (EnumCreatureType)EnumCreatureType.MONSTER, this::buffMob);
            }
        }
    }

    private void buffMob(EntityLiving living) {
        ModifiableAttributeInstance attack = (ModifiableAttributeInstance)living.func_110148_a(SharedMonsterAttributes.field_111264_e);
        ModifiableAttributeInstance health = (ModifiableAttributeInstance)living.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (attack != null && health != null) {
            if (!attack.func_180374_a(SPAWN_BONUS)) {
                attack.func_111121_a(SPAWN_BONUS);
            }
            if (!health.func_180374_a(SPAWN_BONUS)) {
                health.func_111121_a(SPAWN_BONUS);
                living.func_70606_j(living.func_110138_aP());
            }
        }
        ++this.spawnCount;
    }

    @Override
    public boolean onBlockActivated(World worldIn, EntityPlayer playerIn) {
        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.darkutils.monolith.spawning", new Object[]{this.spawnCount}), true);
        return true;
    }

    public void writeNBT(NBTTagCompound dataTag) {
        dataTag.func_74768_a("SpawnCount", this.spawnCount);
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.spawnCount = dataTag.func_74762_e("SpawnCount");
    }
}

