/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.attributerings;

import java.util.UUID;
import net.darkhax.bookshelf.data.AttributeOperation;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public enum AttrRingType {
    HEALTH(SharedMonsterAttributes.field_111267_a, new AttributeModifier(UUID.fromString("b6168900-17f8-4079-9355-78a498a86654"), "ring_max_health", 2.0, AttributeOperation.ADDITIVE.ordinal())),
    KNOCKBACK(SharedMonsterAttributes.field_111266_c, new AttributeModifier(UUID.fromString("44df28ca-7317-47b1-90e8-a43999c137be"), "ring_knockback_res", 0.1, AttributeOperation.MULTIPLY.ordinal())),
    SPEED(SharedMonsterAttributes.field_111263_d, new AttributeModifier(UUID.fromString("868df2f2-bfbe-4567-a26a-cbde8c96dd4a"), "ring_movement_speed", 0.1, AttributeOperation.MULTIPLY.ordinal())),
    DAMAGE(SharedMonsterAttributes.field_111264_e, new AttributeModifier(UUID.fromString("587b65d5-6e90-4129-8f29-c6e6c23ab99e"), "ring_attack_damage", 2.0, AttributeOperation.ADDITIVE.ordinal())),
    ARMOR(SharedMonsterAttributes.field_188791_g, new AttributeModifier(UUID.fromString("746871b7-c19f-4d86-98a6-3c2c2ce9f9ae"), "ring_armor", 2.0, AttributeOperation.ADDITIVE.ordinal())),
    LUCK(SharedMonsterAttributes.field_188792_h, new AttributeModifier(UUID.fromString("0ce2745a-8960-4db4-a770-507e14bdb499"), "ring_luck", 1.0, AttributeOperation.ADDITIVE.ordinal())),
    ATTACK_SPEED(SharedMonsterAttributes.field_188790_f, new AttributeModifier(UUID.fromString("c9c5001e-6bf6-4812-8748-a42ed04b809b"), "ring_attack_speed", 0.1, AttributeOperation.MULTIPLY.ordinal())),
    ARMOR_TOUGHNESS(SharedMonsterAttributes.field_189429_h, new AttributeModifier(UUID.fromString("db762e92-9f19-4006-9f53-d9f9a3a17d88"), "ring_armor_toughness", 4.0, AttributeOperation.ADDITIVE.ordinal())),
    REACH(EntityPlayer.REACH_DISTANCE, new AttributeModifier(UUID.fromString("e6134098-e755-47b4-a43f-4d39609989f5"), "ring_reach", 2.0, AttributeOperation.ADDITIVE.ordinal()));

    final IAttribute attribute;
    final AttributeModifier modifier;

    private AttrRingType(IAttribute attribute, AttributeModifier modifier) {
        this.attribute = attribute;
        this.modifier = modifier;
    }

    public void apply(EntityLivingBase entity) {
        ModifiableAttributeInstance instance = (ModifiableAttributeInstance)entity.func_110148_a(this.attribute);
        instance.func_111121_a(this.modifier);
    }

    public void remove(EntityLivingBase entity) {
        ModifiableAttributeInstance instance = (ModifiableAttributeInstance)entity.func_110148_a(this.attribute);
        instance.func_111124_b(this.modifier);
    }

    public String getTooltipText() {
        return TextFormatting.BLUE + " " + I18n.func_74837_a((String)("attribute.modifier.plus." + this.modifier.func_111169_c()), (Object[])new Object[]{MathsUtils.round((double)this.modifier.func_111164_d(), (int)1), I18n.func_74838_a((String)("attribute.name." + this.attribute.func_111108_a()))});
    }
}

