/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="interdiction")
public class RitualInterdiction
extends Ritual {
    public static final String INTERDICTION_RANGE = "interdictionRange";

    public RitualInterdiction() {
        super("ritualInterdiction", 0, 1000, "ritual.bloodmagic.interdictionRitual");
        this.addBlockRange(INTERDICTION_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 0, -2), 5));
        this.setMaximumVolumeAndDistanceOfRange(INTERDICTION_RANGE, 0, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor interdictionRange = masterRitualStone.getBlockRange(INTERDICTION_RANGE);
        for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, interdictionRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).func_146103_bH().getId().equals(masterRitualStone.getOwner()))) continue;
            double xDif = entity.field_70165_t - ((double)masterRitualStone.getBlockPos().func_177958_n() + 0.5);
            double yDif = entity.field_70163_u - (double)masterRitualStone.getBlockPos().func_177956_o() + 1.0;
            double zDif = entity.field_70161_v - ((double)masterRitualStone.getBlockPos().func_177952_p() + 0.5);
            entity.field_70159_w = 0.1 * xDif;
            entity.field_70181_x = 0.1 * yDif;
            entity.field_70179_y = 0.1 * zDif;
            entity.field_70143_R = 0.0f;
            if (!(entity instanceof EntityPlayer)) continue;
            entity.field_70133_I = true;
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, 0, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualInterdiction();
    }
}

