/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="feathered_earth")
public class RitualFeatheredEarth
extends Ritual {
    public static final String FALL_PROTECTION_RANGE = "fallProtRange";

    public RitualFeatheredEarth() {
        super("ritualFeatheredEarth", 0, 5000, "ritual.bloodmagic.featheredEarthRitual");
        this.addBlockRange(FALL_PROTECTION_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-25, 0, -25), new BlockPos(25, 30, 25)));
        this.setMaximumVolumeAndDistanceOfRange(FALL_PROTECTION_RANGE, 0, 200, 200);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        if (masterRitualStone.getCooldown() > 0) {
            world.func_72942_c((Entity)new EntityLightningBolt(world, x + 4.0, y + 5.0, z + 4.0, false));
            world.func_72942_c((Entity)new EntityLightningBolt(world, x + 4.0, y + 5.0, z - 4.0, false));
            world.func_72942_c((Entity)new EntityLightningBolt(world, x - 4.0, y + 5.0, z - 4.0, false));
            world.func_72942_c((Entity)new EntityLightningBolt(world, x - 4.0, y + 5.0, z + 4.0, false));
            masterRitualStone.setCooldown(0);
        }
        AreaDescriptor fallProtRange = masterRitualStone.getBlockRange(FALL_PROTECTION_RANGE);
        AxisAlignedBB fallProtBB = fallProtRange.getAABB(masterRitualStone.getBlockPos());
        List entities = world.func_72872_a(EntityLivingBase.class, fallProtBB);
        for (EntityLivingBase entity : entities) {
            if (totalEffects >= maxEffects) break;
            entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.FEATHERED, 20, 0));
            ++totalEffects;
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 10;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 3, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 3, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 4, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 4, 5, 5, EnumRuneType.AIR);
        this.addOffsetRunes(components, 3, 4, 5, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFeatheredEarth();
    }
}

