/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

@RitualRegister(value="crystal_harvest")
public class RitualCrystalHarvest
extends Ritual {
    public static final String CRYSTAL_RANGE = "crystal";

    public RitualCrystalHarvest() {
        super("ritualCrystalHarvest", 0, 40000, "ritual.bloodmagic.crystalHarvestRitual");
        this.addBlockRange(CRYSTAL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-3, 2, -3), 7, 5, 7));
        this.setMaximumVolumeAndDistanceOfRange(CRYSTAL_RANGE, 250, 5, 7);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = 1;
        int totalEffects = 0;
        AreaDescriptor crystalRange = masterRitualStone.getBlockRange(CRYSTAL_RANGE);
        crystalRange.resetIterator();
        while (crystalRange.hasNext()) {
            TileDemonCrystal demonCrystal;
            BlockPos nextPos = ((BlockPos)crystalRange.next()).func_177971_a((Vec3i)pos);
            TileEntity tile = world.func_175625_s(nextPos);
            if (!(tile instanceof TileDemonCrystal) || !(demonCrystal = (TileDemonCrystal)tile).dropSingleCrystal()) continue;
            IBlockState state = world.func_180495_p(nextPos);
            world.func_184138_a(nextPos, state, state, 3);
            if (++totalEffects < maxEffects) continue;
            break;
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, 1, EnumRuneType.DUSK);
        this.addParallelRunes(components, 1, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, -1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 3, 1, -1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrystalHarvest();
    }
}

