/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.recipe.alchemyTable;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AlchemyTableRecipe {
    protected ItemStack output = ItemStack.field_190927_a;
    protected ArrayList<Object> input = new ArrayList();
    protected int lpDrained;
    protected int ticksRequired;
    protected int tierRequired;

    public AlchemyTableRecipe(Block result, int lpDrained, int ticksRequired, int tierRequired, Object ... recipe) {
        this(new ItemStack(result), lpDrained, ticksRequired, tierRequired, recipe);
    }

    public AlchemyTableRecipe(Item result, int lpDrained, int ticksRequired, int tierRequired, Object ... recipe) {
        this(new ItemStack(result), lpDrained, ticksRequired, tierRequired, recipe);
    }

    public AlchemyTableRecipe(ItemStack result, int lpDrained, int ticksRequired, int tierRequired, Object ... recipe) {
        this.output = result.func_77946_l();
        this.lpDrained = lpDrained;
        this.ticksRequired = ticksRequired;
        this.tierRequired = tierRequired;
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            StringBuilder ret = new StringBuilder("Invalid alchemy recipe: ");
            for (Object tmp : recipe) {
                ret.append(tmp).append(", ");
            }
            ret.append(this.output);
            throw new RuntimeException(ret.toString());
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput(List<ItemStack> inputList) {
        return this.output.func_77946_l();
    }

    public boolean matches(List<ItemStack> checkedList, World world, BlockPos pos) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (ItemStack slot : checkedList) {
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            for (Object aRequired : required) {
                boolean match = false;
                if (aRequired instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)aRequired), (ItemStack)slot, (boolean)false);
                } else if (aRequired instanceof List) {
                    Iterator itr = ((List)aRequired).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(aRequired);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public List<Object> getInput() {
        return ImmutableList.copyOf(this.input);
    }

    public ItemStack[] getRemainingItems(ItemStack[] inventory) {
        ItemStack[] ret = (ItemStack[])inventory.clone();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getContainerItem(inventory[i]);
        }
        return ret;
    }

    protected ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copyStack = stack.func_77946_l();
        if (copyStack.func_77973_b().hasContainerItem(stack)) {
            return copyStack.func_77973_b().getContainerItem(copyStack);
        }
        copyStack.func_190918_g(1);
        if (copyStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return copyStack;
    }

    public int getLpDrained() {
        return this.lpDrained;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public int getTierRequired() {
        return this.tierRequired;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("output", (Object)this.output).append("input", this.input).append("lpDrained", this.lpDrained).append("ticksRequired", this.ticksRequired).append("tierRequired", this.tierRequired).append("recipeSize", this.getRecipeSize()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlchemyTableRecipe)) {
            return false;
        }
        AlchemyTableRecipe that = (AlchemyTableRecipe)o;
        if (this.lpDrained != that.lpDrained) {
            return false;
        }
        if (this.ticksRequired != that.ticksRequired) {
            return false;
        }
        if (this.tierRequired != that.tierRequired) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        return this.input != null ? this.input.equals(that.input) : that.input == null;
    }

    public int hashCode() {
        int result = this.output != null ? this.output.hashCode() : 0;
        result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
        result = 31 * result + this.lpDrained;
        result = 31 * result + this.ticksRequired;
        result = 31 * result + this.tierRequired;
        return result;
    }
}

