/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.inventory;

import WayofTime.bloodmagic.util.helper.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ItemInventory
implements IInventory {
    protected int[] syncedSlots = new int[0];
    protected ItemStack masterStack;
    private NonNullList<ItemStack> inventory;
    private int size;
    private String name;

    public ItemInventory(ItemStack masterStack, int size, String name) {
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.size = size;
        this.name = name;
        this.masterStack = masterStack;
        if (!masterStack.func_190926_b()) {
            this.readFromStack(masterStack);
        }
    }

    public void initializeInventory(ItemStack masterStack) {
        this.masterStack = masterStack;
        this.func_174888_l();
        this.readFromStack(masterStack);
    }

    private boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList tags = tagCompound.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data;
            byte j;
            if (this.isSyncedSlot(i) || (j = (data = tags.func_150305_b(i)).func_74771_c("Slot")) < 0 || j >= this.inventory.size()) continue;
            this.inventory.set(i, (Object)new ItemStack(data));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b() || this.isSyncedSlot(i)) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tags);
    }

    public void readFromStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            NBTTagCompound tag = masterStack.func_77978_p();
            this.readFromNBT(tag.func_74775_l("itemInventory"));
        }
    }

    public void writeToStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            NBTTagCompound tag = masterStack.func_77978_p();
            NBTTagCompound invTag = new NBTTagCompound();
            this.writeToNBT(invTag);
            tag.func_74782_a("itemInventory", (NBTBase)invTag);
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(index)).func_190916_E() <= count) {
                ItemStack itemStack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = ((ItemStack)this.inventory.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventory.get(index)).func_190926_b()) {
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            ItemStack itemStack = (ItemStack)this.inventory.get(slot);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void func_70296_d() {
        if (this.masterStack != null) {
            this.writeToStack(this.masterStack);
        }
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean canInventoryBeManipulated() {
        return this.masterStack != null;
    }
}

