/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.event;

import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.imperfect.IImperfectRitualStone;
import WayofTime.bloodmagic.ritual.imperfect.ImperfectRitual;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RitualEvent
extends Event {
    private final IMasterRitualStone mrs;
    private final UUID ownerId;
    private final Ritual ritual;

    private RitualEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual) {
        this.mrs = mrs;
        this.ownerId = ownerId;
        this.ritual = ritual;
    }

    public IMasterRitualStone getRitualStone() {
        return this.mrs;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public Ritual getRitual() {
        return this.ritual;
    }

    @Cancelable
    public static class ImperfectRitualActivatedEvent
    extends Event {
        private final IImperfectRitualStone ims;
        private final EntityPlayer activator;
        private final ImperfectRitual imperfectRitual;

        public ImperfectRitualActivatedEvent(IImperfectRitualStone ims, EntityPlayer activator, ImperfectRitual imperfectRitual) {
            this.ims = ims;
            this.activator = activator;
            this.imperfectRitual = imperfectRitual;
        }

        public IImperfectRitualStone getRitualStone() {
            return this.ims;
        }

        public EntityPlayer getActivator() {
            return this.activator;
        }

        public ImperfectRitual getImperfectRitual() {
            return this.imperfectRitual;
        }
    }

    public static class RitualStopEvent
    extends RitualEvent {
        private final Ritual.BreakType method;

        public RitualStopEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual, Ritual.BreakType method) {
            super(mrs, ownerId, ritual);
            this.method = method;
        }

        public Ritual.BreakType getMethod() {
            return this.method;
        }
    }

    @Cancelable
    public static class RitualRunEvent
    extends RitualEvent {
        public RitualRunEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual) {
            super(mrs, ownerId, ritual);
        }
    }

    @Cancelable
    public static class RitualActivatedEvent
    extends RitualEvent {
        private final EntityPlayer player;
        private final ItemStack crystalStack;
        private final int crystalTier;

        public RitualActivatedEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual, EntityPlayer player, ItemStack activationCrystal, int crystalTier) {
            super(mrs, ownerId, ritual);
            this.player = player;
            this.crystalStack = activationCrystal;
            this.crystalTier = crystalTier;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public ItemStack getCrystalStack() {
            return this.crystalStack;
        }

        public int getCrystalTier() {
            return this.crystalTier;
        }
    }
}

