/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.projectile;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySentientArrow
extends EntityTippedArrow {
    public PotionType field_184560_g = PotionTypes.field_185229_a;
    public double reimbursedAmountOnHit = 0.0;
    public EnumDemonWillType type = EnumDemonWillType.DEFAULT;
    public int currentLevel = 0;
    public ItemStack itemStack;
    public Class<? extends EntityArrow> specialArrowClass;
    public float[] destructiveExplosionRadius = new float[]{0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f};
    public int[] poisonDuration = new int[]{50, 100, 150, 80, 120, 160, 200};
    public int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};
    public int[] levitationDuration = new int[]{20, 40, 60, 80, 100, 120, 160};
    public int[] levitationLevel = new int[]{0, 0, 0, 1, 1, 1, 2};
    public int[] slownessDuration = new int[]{40, 60, 100, 150, 200, 250, 300};
    public int[] slownessLevel = new int[]{0, 0, 0, 1, 1, 1, 2};
    public EntityArrow specialEntity;
    public MethodHandle specialHitMH;
    public Method specialHit;

    public EntitySentientArrow(World worldIn) {
        super(worldIn);
    }

    public EntitySentientArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntitySentientArrow(World worldIn, EntityLivingBase shooter, EnumDemonWillType type, double reimburseAmount, int currentLevel) {
        super(worldIn, shooter);
        this.reimbursedAmountOnHit = reimburseAmount;
        this.type = type;
        this.currentLevel = currentLevel;
    }

    public EntitySentientArrow(World worldIn, EntityLivingBase shooter, EnumDemonWillType type, double reimburseAmount, int currentLevel, PotionType potion) {
        super(worldIn, shooter);
        this.reimbursedAmountOnHit = reimburseAmount;
        this.type = type;
        this.currentLevel = currentLevel;
        this.field_184560_g = potion;
    }

    public EntitySentientArrow(World worldIn, EntityLivingBase shooter, EnumDemonWillType type, double reimburseAmount, int currentLevel, ItemStack itemStack) {
        super(worldIn, shooter);
        this.reimbursedAmountOnHit = reimburseAmount;
        this.type = type;
        this.currentLevel = currentLevel;
        this.field_184560_g = PotionUtils.func_185191_c((ItemStack)itemStack);
    }

    public EntitySentientArrow(World worldIn, EntityLivingBase shooter, EnumDemonWillType type, double reimburseAmount, int currentLevel, EntityArrow specialArrow) {
        super(worldIn, shooter);
        this.reimbursedAmountOnHit = reimburseAmount;
        this.type = type;
        this.currentLevel = currentLevel;
        this.specialEntity = specialArrow;
        this.specialArrowClass = specialArrow.getClass();
    }

    public void reimbursePlayer(EntityLivingBase hitEntity, float damage) {
        if (this.field_70250_c instanceof EntityPlayer) {
            if (hitEntity.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && !(hitEntity instanceof IMob)) {
                return;
            }
            PlayerDemonWillHandler.addDemonWill(this.type, (EntityPlayer)this.field_70250_c, this.reimbursedAmountOnHit * (double)damage / 20.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_184548_a(EntityLivingBase living) {
        int amp = -1;
        switch (this.type) {
            case CORROSIVE: {
                if (this.field_184560_g != null) {
                    for (PotionEffect i : this.field_184560_g.func_185170_a()) {
                        if (i.func_76453_d().equals("poison")) {
                            amp = i.func_76458_c();
                            continue;
                        }
                        living.func_70690_d(new PotionEffect(i.func_188419_a(), i.func_76459_b(), i.func_76458_c()));
                    }
                }
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.currentLevel >= 0 ? (amp > -1 && this.poisonLevel[this.currentLevel] != amp ? this.poisonDuration[this.currentLevel] / 2 : this.poisonDuration[this.currentLevel]) : 0, this.currentLevel >= 0 ? (amp > -1 ? Math.max(this.poisonLevel[this.currentLevel], amp) + 1 : this.poisonLevel[this.currentLevel]) : 0));
                break;
            }
            case DEFAULT: {
                if (this.field_184560_g == null) break;
                for (PotionEffect i : this.field_184560_g.func_185170_a()) {
                    living.func_70690_d(new PotionEffect(i.func_188419_a(), i.func_76459_b(), i.func_76458_c()));
                }
                break;
            }
            case DESTRUCTIVE: {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.currentLevel >= 0 ? this.destructiveExplosionRadius[this.currentLevel] : 0.0f, false);
                this.createPotionFromArrow(living);
                break;
            }
            case STEADFAST: {
                if (this.field_184560_g != null) {
                    for (PotionEffect i : this.field_184560_g.func_185170_a()) {
                        if (i.func_76453_d().equals("levitation")) {
                            amp = i.func_76458_c();
                            continue;
                        }
                        living.func_70690_d(new PotionEffect(i.func_188419_a(), i.func_76459_b(), i.func_76458_c()));
                    }
                }
                living.func_70690_d(new PotionEffect(MobEffects.field_188424_y, this.currentLevel >= 0 ? (amp > -1 && this.levitationLevel[this.currentLevel] != amp ? this.levitationDuration[this.currentLevel] / 2 : this.levitationDuration[this.currentLevel]) : 0, this.currentLevel >= 0 ? (amp > -1 ? Math.max(this.levitationLevel[this.currentLevel], amp) + 1 : this.levitationLevel[this.currentLevel]) : 0));
                break;
            }
            case VENGEFUL: {
                if (this.field_184560_g != null) {
                    for (PotionEffect i : this.field_184560_g.func_185170_a()) {
                        if (i.func_76453_d().equals("slowness")) {
                            amp = i.func_76458_c();
                            continue;
                        }
                        living.func_70690_d(new PotionEffect(i.func_188419_a(), i.func_76459_b(), i.func_76458_c()));
                    }
                }
                living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.currentLevel >= 0 ? (amp > -1 && this.slownessLevel[this.currentLevel] != amp ? this.slownessDuration[this.currentLevel] / 2 : this.slownessDuration[this.currentLevel]) : 0, this.currentLevel >= 0 ? (amp > -1 ? Math.max(this.slownessLevel[this.currentLevel], amp) + 1 : this.slownessLevel[this.currentLevel]) : 0));
                break;
            }
        }
        if (this.specialArrowClass != null) {
            try {
                this.specialHit = this.specialArrowClass.getMethod("arrowHit", EntityLivingBase.class);
                this.specialHitMH = MethodHandles.lookup().unreflect(this.specialHit).bindTo(this.specialEntity);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (this.specialHitMH != null) {
                        this.specialHitMH.invoke(living);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.specialArrowClass != null && !this.field_70170_p.field_72995_K) {
            this.specialEntity.field_70165_t = this.field_70165_t;
            this.specialEntity.field_70163_u = this.field_70163_u;
            this.specialEntity.field_70161_v = this.field_70161_v;
            this.specialEntity.func_70071_h_();
            if (this.field_70254_i) {
                this.specialEntity.func_70106_y();
            }
        }
        switch (this.type) {
            case DESTRUCTIVE: {
                if (this.field_184560_g != null) {
                    this.func_184556_b(2);
                }
                if (this.field_70170_p.field_72995_K || !this.field_70254_i) break;
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.currentLevel >= 0 ? this.destructiveExplosionRadius[this.currentLevel] : 0.0f, false);
                if (this.field_184560_g != null && this.specialArrowClass == null) {
                    this.createPotionFromArrow(null);
                }
                this.func_70106_y();
                break;
            }
            case CORROSIVE: {
                this.func_184556_b(2);
                break;
            }
            case DEFAULT: {
                if (this.field_184560_g == null) break;
                this.func_184556_b(2);
                break;
            }
            case STEADFAST: {
                if (this.field_184560_g == null) break;
                this.func_184556_b(2);
                break;
            }
            case VENGEFUL: {
                if (this.field_184560_g == null) break;
                this.func_184556_b(2);
                break;
            }
        }
    }

    private void createPotionFromArrow(EntityLivingBase living) {
        if (this.field_184560_g != null) {
            float radius = this.currentLevel >= 0 ? this.destructiveExplosionRadius[this.currentLevel] : 0.0f;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b((double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f));
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            if (!list.isEmpty()) {
                for (EntityLivingBase entitylivingbase : list) {
                    double d0;
                    if (!entitylivingbase.func_184603_cC() || !((d0 = this.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                    double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                    if (entitylivingbase == living) {
                        d1 = 1.0;
                    }
                    for (PotionEffect potioneffect : this.field_184560_g.func_185170_a()) {
                        Potion potion = potioneffect.func_188419_a();
                        if (potion.func_76403_b()) {
                            potion.func_180793_a((Entity)this, this.field_70250_c, entitylivingbase, potioneffect.func_76458_c(), d1);
                            continue;
                        }
                        int i = (int)(d1 * (double)potioneffect.func_76459_b() + 0.5);
                        if (i <= 20) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(potion, i, potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
                    }
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74780_a("reimbursement", this.reimbursedAmountOnHit);
        tag.func_74768_a("currentLevel", this.currentLevel);
        tag.func_74778_a("demonWillType", this.type.toString());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.reimbursedAmountOnHit = tag.func_74769_h("reimbursement");
        this.type = EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
        this.currentLevel = tag.func_74762_e("currentLevel");
    }

    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }

    public void func_184556_b(int particleCount) {
        int i = this.func_184557_n();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }
}

