/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core.data;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class SoulTicket {
    private static final ITextComponent EMPTY = new TextComponentString("");
    private final ITextComponent description;
    private final int amount;

    public SoulTicket(ITextComponent description, int amount) {
        this.description = description;
        this.amount = amount;
    }

    public SoulTicket(int amount) {
        this(EMPTY, amount);
    }

    public boolean isSyphon() {
        return this.amount < 0;
    }

    public ITextComponent getDescription() {
        return this.description;
    }

    public int getAmount() {
        return this.amount;
    }

    public static SoulTicket block(World world, BlockPos pos, int amount) {
        return new SoulTicket((ITextComponent)new TextComponentString("block|" + world.field_73011_w.getDimension() + "|" + pos.func_177986_g()), amount);
    }

    public static SoulTicket item(ItemStack itemStack, World world, Entity entity, int amount) {
        return new SoulTicket((ITextComponent)new TextComponentString("item|" + itemStack.func_77973_b().getRegistryName() + "|" + world.field_73011_w.getDimension() + "|" + entity.getPersistentID()), amount);
    }

    public static SoulTicket item(ItemStack itemStack, World world, BlockPos pos, int amount) {
        return new SoulTicket((ITextComponent)new TextComponentString("item|" + itemStack.func_77973_b().getRegistryName() + "|" + world.field_73011_w.getDimension() + "|" + pos.func_177986_g()), amount);
    }

    public static SoulTicket item(ItemStack itemStack, int amount) {
        return new SoulTicket((ITextComponent)new TextComponentString("item|" + itemStack.func_77973_b().getRegistryName()), amount);
    }

    public static SoulTicket command(ICommandSender sender, String command, int amount) {
        return new SoulTicket((ITextComponent)new TextComponentString("command|" + command + "|" + sender.func_70005_c_()), amount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SoulTicket) {
            return ((SoulTicket)o).getDescription().equals(this.description);
        }
        return false;
    }

    public int hashCode() {
        return this.description.hashCode();
    }
}

