/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.jei;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyArray;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyTable;
import WayofTime.bloodmagic.api.impl.recipe.RecipeBloodAltar;
import WayofTime.bloodmagic.api.impl.recipe.RecipeTartaricForge;
import WayofTime.bloodmagic.block.enums.EnumDecorative;
import WayofTime.bloodmagic.client.gui.GuiSoulForge;
import WayofTime.bloodmagic.compat.jei.alchemyArray.AlchemyArrayCraftingCategory;
import WayofTime.bloodmagic.compat.jei.alchemyArray.AlchemyArrayCraftingRecipeJEI;
import WayofTime.bloodmagic.compat.jei.alchemyTable.AlchemyTableRecipeCategory;
import WayofTime.bloodmagic.compat.jei.alchemyTable.AlchemyTableRecipeJEI;
import WayofTime.bloodmagic.compat.jei.altar.AltarRecipeCategory;
import WayofTime.bloodmagic.compat.jei.altar.AltarRecipeJEI;
import WayofTime.bloodmagic.compat.jei.armourDowngrade.ArmourDowngradeRecipeCategory;
import WayofTime.bloodmagic.compat.jei.armourDowngrade.ArmourDowngradeRecipeHandler;
import WayofTime.bloodmagic.compat.jei.armourDowngrade.ArmourDowngradeRecipeMaker;
import WayofTime.bloodmagic.compat.jei.binding.BindingRecipeCategory;
import WayofTime.bloodmagic.compat.jei.binding.BindingRecipeHandler;
import WayofTime.bloodmagic.compat.jei.binding.BindingRecipeMaker;
import WayofTime.bloodmagic.compat.jei.forge.TartaricForgeRecipeCategory;
import WayofTime.bloodmagic.compat.jei.forge.TartaricForgeRecipeJEI;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.AlchemyTableRecipeRegistry;
import WayofTime.bloodmagic.livingArmour.LivingArmourHandler;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTableRecipe;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class BloodMagicJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;

    public void register(@Nonnull IModRegistry registry) {
        jeiHelper = registry.getJeiHelpers();
        registry.addRecipeHandlers(new IRecipeHandler[]{new BindingRecipeHandler(), new ArmourDowngradeRecipeHandler()});
        registry.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAltarRecipes(), "bloodmagic:altar");
        registry.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForgeRecipes(), "bloodmagic:soulForge");
        registry.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyArrayRecipes(), "bloodmagic:alchemyArray");
        registry.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyRecipes(), "bloodmagic:salchemyTable");
        registry.addRecipes(AlchemyTableRecipeRegistry.getRecipeList(), "bloodmagic:salchemyTable");
        registry.addRecipes(this.getAnvilRecipes(), "minecraft.anvil");
        registry.handleRecipes(RecipeBloodAltar.class, AltarRecipeJEI::new, "bloodmagic:altar");
        registry.handleRecipes(RecipeTartaricForge.class, TartaricForgeRecipeJEI::new, "bloodmagic:soulForge");
        registry.handleRecipes(RecipeAlchemyArray.class, AlchemyArrayCraftingRecipeJEI::new, "bloodmagic:alchemyArray");
        registry.handleRecipes(RecipeAlchemyTable.class, AlchemyTableRecipeJEI::new, "bloodmagic:salchemyTable");
        registry.handleRecipes(AlchemyTableRecipe.class, AlchemyTableRecipeJEI::new, "bloodmagic:salchemyTable");
        registry.addRecipes(BindingRecipeMaker.getRecipes());
        registry.addRecipes(ArmourDowngradeRecipeMaker.getRecipes());
        registry.addIngredientInfo((Object)new ItemStack(RegistrarBloodMagicItems.ALTAR_MAKER), ItemStack.class, new String[]{"jei.bloodmagic.desc.altarBuilder"});
        registry.addIngredientInfo((Object)new ItemStack(RegistrarBloodMagicItems.MONSTER_SOUL), ItemStack.class, new String[]{"jei.bloodmagic.desc.demonicWill"});
        for (Map.Entry<String, Integer> entry : LivingArmourHandler.upgradeMaxLevelMap.entrySet()) {
            String key = entry.getKey();
            int maxLevel = entry.getValue();
            for (int i = 0; i < maxLevel - 1; ++i) {
                ItemStack stack = new ItemStack(RegistrarBloodMagicItems.UPGRADE_TOME);
                ItemHelper.LivingUpgrades.setKey(stack, key);
                ItemHelper.LivingUpgrades.setLevel(stack, i);
                jeiHelper.getIngredientBlacklist().addIngredientToBlacklist((Object)stack);
            }
        }
        registry.addRecipeClickArea(GuiSoulForge.class, 115, 15, 16, 88, new String[]{"bloodmagic:soulForge"});
        registry.addRecipeCatalyst((Object)new ItemStack(RegistrarBloodMagicBlocks.ALTAR), new String[]{"bloodmagic:altar"});
        registry.addRecipeCatalyst((Object)new ItemStack(RegistrarBloodMagicBlocks.SOUL_FORGE), new String[]{"bloodmagic:soulForge"});
        registry.addRecipeCatalyst((Object)new ItemStack(RegistrarBloodMagicItems.ARCANE_ASHES), new String[]{"bloodmagic:alchemyArray"});
        registry.addRecipeCatalyst((Object)new ItemStack(RegistrarBloodMagicItems.ARCANE_ASHES), new String[]{"bloodmagic:binding"});
        registry.addRecipeCatalyst((Object)new ItemStack(RegistrarBloodMagicBlocks.ALCHEMY_TABLE), new String[]{"bloodmagic:salchemyTable"});
        registry.addRecipeCatalyst((Object)new ItemStack(RegistrarBloodMagicBlocks.RITUAL_CONTROLLER), new String[]{"bloodmagic:armourDowngrade"});
        if (!ConfigHandler.general.enableTierSixEvenThoughThereIsNoContent) {
            jeiHelper.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(RegistrarBloodMagicBlocks.DECORATIVE_BRICK, 1, EnumDecorative.CRYSTAL_TILE.ordinal()));
            jeiHelper.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(RegistrarBloodMagicBlocks.DECORATIVE_BRICK, 1, EnumDecorative.CRYSTAL_BRICK.ordinal()));
            jeiHelper.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(RegistrarBloodMagicItems.INSCRIPTION_TOOL, 1, EnumRuneType.DAWN.ordinal()));
        }
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{RegistrarBloodMagicItems.UPGRADE_TOME});
        subtypeRegistry.useNbtForSubtypes(new Item[]{RegistrarBloodMagicItems.POTION_FLASK});
        subtypeRegistry.registerSubtypeInterpreter(RegistrarBloodMagicItems.BLOOD_ORB, stack -> {
            if (!(stack.func_77973_b() instanceof IBloodOrb)) {
                return "";
            }
            BloodOrb orb = ((IBloodOrb)stack.func_77973_b()).getOrb(stack);
            if (orb == null) {
                return "";
            }
            return orb.getRegistryName().toString();
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (jeiHelper == null) {
            jeiHelper = registry.getJeiHelpers();
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new AltarRecipeCategory(), new BindingRecipeCategory(), new AlchemyArrayCraftingCategory(), new TartaricForgeRecipeCategory(), new AlchemyTableRecipeCategory(), new ArmourDowngradeRecipeCategory()});
    }

    public Collection<IRecipeWrapper> getAnvilRecipes() {
        int i;
        IVanillaRecipeFactory vanillaRecipeFactory = jeiHelper.getVanillaRecipeFactory();
        LinkedList<ItemStack> outputSwords = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputPickaxes = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputAxes = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputBows = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputShovels = new LinkedList<ItemStack>();
        LinkedList<ItemStack> inputRightSentient = new LinkedList<ItemStack>();
        LinkedList<LinkedList<ItemStack>> sentientOutputs = new LinkedList<LinkedList<ItemStack>>();
        LinkedList<ItemStack> sentientTools = new LinkedList<ItemStack>();
        sentientTools.add(new ItemStack(RegistrarBloodMagicItems.SENTIENT_AXE));
        sentientTools.add(new ItemStack(RegistrarBloodMagicItems.SENTIENT_PICKAXE));
        sentientTools.add(new ItemStack(RegistrarBloodMagicItems.SENTIENT_BOW));
        sentientTools.add(new ItemStack(RegistrarBloodMagicItems.SENTIENT_SHOVEL));
        sentientTools.add(new ItemStack(RegistrarBloodMagicItems.SENTIENT_SWORD));
        for (int i2 = 4; i2 > 0; --i2) {
            for (ItemStack j : sentientTools) {
                int maxDmg = j.func_77958_k();
                j.func_77964_b(maxDmg - maxDmg / 4 * i2);
            }
            outputAxes.add(((ItemStack)sentientTools.get(0)).func_77946_l());
            outputPickaxes.add(((ItemStack)sentientTools.get(1)).func_77946_l());
            outputBows.add(((ItemStack)sentientTools.get(2)).func_77946_l());
            outputShovels.add(((ItemStack)sentientTools.get(3)).func_77946_l());
            outputSwords.add(((ItemStack)sentientTools.get(4)).func_77946_l());
            inputRightSentient.add(new ItemStack(RegistrarBloodMagicItems.ITEM_DEMON_CRYSTAL, i2));
        }
        sentientOutputs.add(outputAxes);
        sentientOutputs.add(outputPickaxes);
        sentientOutputs.add(outputBows);
        sentientOutputs.add(outputShovels);
        sentientOutputs.add(outputSwords);
        LinkedList<IRecipeWrapper> collection = new LinkedList<IRecipeWrapper>();
        for (int i3 = 0; i3 < 5; ++i3) {
            ItemStack inputLeft = (ItemStack)sentientTools.get(i3);
            inputLeft.func_77964_b(inputLeft.func_77958_k());
            collection.add(vanillaRecipeFactory.createAnvilRecipe(inputLeft, inputRightSentient, (List)sentientOutputs.get(i3)));
        }
        LinkedList<ItemStack> outputHelmets = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputChestplates = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputLeggings = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputBoots = new LinkedList<ItemStack>();
        LinkedList<ItemStack> inputRightLiving = new LinkedList<ItemStack>();
        LinkedList<LinkedList<ItemStack>> livingOutputs = new LinkedList<LinkedList<ItemStack>>();
        LinkedList<ItemStack> livingTools = new LinkedList<ItemStack>();
        livingTools.add(new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_HELMET));
        livingTools.add(new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_CHEST));
        livingTools.add(new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_LEGGINGS));
        livingTools.add(new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_BOOTS));
        for (i = 4; i > 0; --i) {
            for (ItemStack j : livingTools) {
                int maxDmg = j.func_77958_k();
                j.func_77964_b(maxDmg - maxDmg / 4 * i);
            }
            outputHelmets.add(((ItemStack)livingTools.get(0)).func_77946_l());
            outputChestplates.add(((ItemStack)livingTools.get(1)).func_77946_l());
            outputLeggings.add(((ItemStack)livingTools.get(2)).func_77946_l());
            outputBoots.add(((ItemStack)livingTools.get(3)).func_77946_l());
            inputRightLiving.add(new ItemStack(RegistrarBloodMagicItems.COMPONENT, i, 8));
        }
        livingOutputs.add(outputHelmets);
        livingOutputs.add(outputChestplates);
        livingOutputs.add(outputLeggings);
        livingOutputs.add(outputBoots);
        for (i = 0; i < 4; ++i) {
            ItemStack inputLeft = (ItemStack)livingTools.get(i);
            inputLeft.func_77964_b(inputLeft.func_77958_k());
            collection.add(vanillaRecipeFactory.createAnvilRecipe(inputLeft, inputRightLiving, (List)livingOutputs.get(i)));
        }
        return collection;
    }
}

