/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.command.sub;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;

public class SubCommandNetwork
extends CommandTreeBase {
    public SubCommandNetwork() {
        this.addSubcommand((ICommand)new Syphon());
        this.addSubcommand((ICommand)new Add());
        this.addSubcommand((ICommand)new Set());
        this.addSubcommand((ICommand)new Get());
        this.addSubcommand((ICommand)new Cap());
        this.addSubcommand((ICommand)new Fill());
        this.addSubcommand((ICommand)new Tickets());
        this.addSubcommand((ICommand)new CommandTreeHelp((CommandTreeBase)this));
    }

    public String func_71517_b() {
        return "network";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "commands.bloodmagic.network.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    class Tickets
    extends NetworkCommand {
        Tickets() {
        }

        public String func_71517_b() {
            return "tickethistory";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            List<SoulTicket> tickethistory = this.network.getTicketHistory();
            if (!tickethistory.isEmpty()) {
                for (SoulTicket i : this.network.getTicketHistory()) {
                    sender.func_145747_a(i.getDescription());
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.success", new Object[]{this.player.func_145748_c_().func_150254_d()}));
        }
    }

    class Fill
    extends NetworkCommand {
        Fill() {
        }

        @Override
        public String getInfo() {
            return "2147483647";
        }

        public String func_71517_b() {
            return "fill";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.network.setCurrentEssence(Integer.MAX_VALUE);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.network.fill.success", new Object[]{this.player.func_145748_c_().func_150254_d()}));
        }
    }

    class Cap
    extends NetworkCommand {
        Cap() {
        }

        public String func_71517_b() {
            return "cap";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.network.setCurrentEssence(NetworkHelper.getMaximumForTier(this.network.getOrbTier()));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.network.cap.success", new Object[]{this.player.func_145748_c_().func_150254_d()}));
        }
    }

    class Get
    extends NetworkCommand {
        Get() {
        }

        public String func_71517_b() {
            return "get";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.player = args.length < 1 ? Get.func_71521_c((ICommandSender)sender) : Get.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            this.uuid = PlayerHelper.getUUIDFromPlayer((EntityPlayer)this.player).toString();
            this.network = NetworkHelper.getSoulNetwork(this.uuid);
            sender.func_145747_a((ITextComponent)new TextComponentString(this.player != sender ? this.player.func_145748_c_().func_150254_d() + " " : "" + new TextComponentTranslation("tooltip.bloodmagic.sigil.divination.currentEssence", new Object[]{this.network.getCurrentEssence()}).func_150254_d()));
        }
    }

    class Set
    extends NetworkCommand {
        Set() {
        }

        public String func_71517_b() {
            return "set";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Integer amount = this.commandHelperAmount(server, sender, args);
            if (amount == null) {
                return;
            }
            this.network.setCurrentEssence(amount);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.network.set.success", new Object[]{this.player.func_145748_c_().func_150254_d(), amount}));
        }
    }

    class Add
    extends NetworkCommand {
        Add() {
        }

        public String func_71517_b() {
            return "add";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Integer amount = this.commandHelperAmount(server, sender, args);
            if (amount == null) {
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.network.add.success", new Object[]{this.network.add(SoulTicket.command(sender, this.func_71517_b(), amount), NetworkHelper.getMaximumForTier(this.network.getOrbTier())), this.player.func_145748_c_().func_150254_d()}));
        }
    }

    class Syphon
    extends NetworkCommand {
        Syphon() {
        }

        public String func_71517_b() {
            return "syphon";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Integer amount = this.commandHelperAmount(server, sender, args);
            if (amount == null) {
                return;
            }
            int currE = this.network.getCurrentEssence();
            if (amount > currE) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.network.syphon.amountTooHigh", new Object[0]));
                if (currE == 0) {
                    return;
                }
                amount = Math.min(amount, currE);
            }
            this.network.syphonAndDamage((EntityPlayer)this.player, SoulTicket.command(sender, this.func_71517_b(), amount));
            int newE = this.network.getCurrentEssence();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.network.syphon.success", new Object[]{currE - newE, this.player.func_145748_c_().func_150254_d()}));
        }
    }

    abstract class NetworkCommand
    extends CommandTreeBase {
        public EntityPlayerMP player;
        public SoulNetwork network;
        public String uuid;

        NetworkCommand() {
        }

        public Integer commandHelperAmount(MinecraftServer server, ICommandSender sender, String[] args) {
            int amount;
            if (args.length == 0) {
                amount = 1000;
            } else if (Utils.isInteger(args[0])) {
                amount = Integer.parseInt(args[0]);
            } else if (args.length > 1 && Utils.isInteger(args[1])) {
                amount = Integer.parseInt(args[1]);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.error.arg.invalid", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
                return null;
            }
            if (amount < 0) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.error.negative", new Object[0]));
                return null;
            }
            return amount;
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.bloodmagic.network." + this.func_71517_b() + ".usage";
        }

        public String getHelp() {
            return "commands.bloodmagic.network." + this.func_71517_b() + ".help";
        }

        public String getInfo() {
            return "";
        }

        public final void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length == 1 && (args[0].equals("?") || args[0].equals("help"))) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.getHelp(), new Object[0]));
                return;
            }
            if (!this.func_71517_b().equals("get")) {
                this.player = args.length < 2 ? NetworkCommand.func_71521_c((ICommandSender)sender) : NetworkCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                this.uuid = PlayerHelper.getUUIDFromPlayer((EntityPlayer)this.player).toString();
                this.network = NetworkHelper.getSoulNetwork(this.uuid);
            }
            this.subExecute(server, sender, args);
        }

        protected abstract void subExecute(MinecraftServer var1, ICommandSender var2, String ... var3) throws CommandException;
    }
}

