/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.poweradapters.adapters.caps;

import com.jarhax.poweradapters.adapters.IPowerAdapter;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyStorageAdapter
extends EnergyStorage {
    private final IPowerAdapter adapter;

    public EnergyStorageAdapter(int capacity, IPowerAdapter adapter) {
        super(capacity);
        this.adapter = adapter;
    }

    public EnergyStorageAdapter(int capacity, int maxTransfer, IPowerAdapter adapter) {
        super(capacity, maxTransfer);
        this.adapter = adapter;
    }

    public EnergyStorageAdapter(int capacity, int maxReceive, int maxExtract, IPowerAdapter adapter) {
        super(capacity, maxReceive, maxExtract);
        this.adapter = adapter;
    }

    public EnergyStorageAdapter(int capacity, int maxReceive, int maxExtract, int energy, IPowerAdapter adapter) {
        super(capacity, maxReceive, maxExtract, energy);
        this.adapter = adapter;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.adapter.addPower(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.adapter.takePower(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return (int)this.adapter.getLocalStored();
    }

    public int getMaxEnergyStored() {
        return (int)this.adapter.getLocalCapacity();
    }

    public boolean canExtract() {
        return this.adapter.getLocalOutput() > 0L;
    }

    public boolean canReceive() {
        return this.adapter.getLocalInput() > 0L;
    }
}

