/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.poweradapters;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    private static Configuration config = null;
    public static int maxCapacity = 5000;
    public static int maxInput = 500;
    public static int maxOutput = 500;
    public static int worthTesla = 25;
    public static int worthRedstoneFlux = 25;
    public static int worthForgeUnits = 25;
    public static int worthMinecraftJoules = 100;

    public static void initConfig(File file) {
        config = new Configuration(file);
        ConfigurationHandler.syncConfig();
    }

    public static void syncConfig() {
        maxCapacity = config.getInt("converterCapacity", "general", 5000, 1, Integer.MAX_VALUE, "The maximum amount of power the converter can hold.");
        maxInput = config.getInt("converterInputRate", "general", 500, 1, Integer.MAX_VALUE, "The maximum amount of power the converter can accept");
        maxOutput = config.getInt("converterOutputRate", "general", 500, 1, Integer.MAX_VALUE, "The maximum amount of power the converter can release");
        worthTesla = ConfigurationHandler.getConversionCost("Tesla", 25);
        worthRedstoneFlux = ConfigurationHandler.getConversionCost("RF", 25);
        worthForgeUnits = ConfigurationHandler.getConversionCost("FU", 25);
        worthMinecraftJoules = ConfigurationHandler.getConversionCost("MJ", 100);
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static int getConversionCost(String name, int defaultValue) {
        return config.getInt("convert" + name, "general", defaultValue, 1, 1024, "The amount of internal power one unit of " + name + " is worth.");
    }
}

