/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.entity.EntitySpeedboat;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ConsumeBoatFuelPacket
implements IMessage {
    public int amount;

    public ConsumeBoatFuelPacket() {
    }

    public ConsumeBoatFuelPacket(int amount) {
        this.amount = amount;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
    }

    private static class DoSync
    implements Runnable {
        private EntityPlayer p;
        private int amount;

        public DoSync(EntityPlayer p, int amount) {
            this.p = p;
            this.amount = amount;
        }

        @Override
        public void run() {
            Entity entity;
            if (this.p != null && (entity = this.p.func_184187_bx()) instanceof EntitySpeedboat) {
                EntitySpeedboat boat = (EntitySpeedboat)entity;
                FluidStack fluid = boat.getContainedFluid();
                if (fluid != null) {
                    fluid.amount = Math.max(0, fluid.amount - this.amount);
                }
                boat.setContainedFluid(fluid);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<ConsumeBoatFuelPacket, IMessage> {
        public IMessage onMessage(ConsumeBoatFuelPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            DimensionManager.getWorld((int)player.field_70170_p.field_73011_w.getDimension()).func_152344_a((Runnable)new DoSync((EntityPlayer)player, message.amount));
            return null;
        }
    }
}

