/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mpbasic.network;

import com.gendeathrow.mpbasic.api.IInfoPanelData;
import com.gendeathrow.mpbasic.client.gui.GuiInfoPanel;
import com.gendeathrow.mpbasic.client.gui.GuiScreenOverlay;
import com.gendeathrow.mpbasic.common.infopanel.CapabilityInfoPanel;
import com.gendeathrow.mpbasic.configs.InfoPanelConfigHandler;
import com.gendeathrow.mputils.core.MPUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class InfoPanelUpdate
implements IMessage {
    private String infopanelPage;
    private boolean hasSeenPage = false;

    public InfoPanelUpdate() {
    }

    public InfoPanelUpdate(String infoPanelPageIn) {
        this.infopanelPage = infoPanelPageIn;
    }

    public InfoPanelUpdate(String infoPanelPageIn, boolean hasSeenIn) {
        this.infopanelPage = infoPanelPageIn;
        this.hasSeenPage = hasSeenIn;
    }

    public void fromBytes(ByteBuf buf) {
        this.infopanelPage = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.hasSeenPage = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.infopanelPage);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.hasSeenPage ? 1 : 0));
    }

    public static class ServerHandler
    implements IMessageHandler<InfoPanelUpdate, IMessage> {
        public IMessage onMessage(final InfoPanelUpdate message, final MessageContext ctx) {
            if (message == null || message.infopanelPage == null) {
                MPUtils.logger.log(Level.ERROR, "A critical NPE error occured during while handling a MPBasic Tools packet Server side", (Throwable)new NullPointerException());
                return null;
            }
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    IInfoPanelData cap = CapabilityInfoPanel.getInfoPanelData((EntityPlayer)ctx.getServerHandler().field_147369_b);
                    if (cap != null) {
                        cap.addBookPanel(message.infopanelPage);
                    }
                }
            });
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<InfoPanelUpdate, IMessage> {
        public IMessage onMessage(final InfoPanelUpdate message, MessageContext ctx) {
            if (message == null || message.infopanelPage == null) {
                MPUtils.logger.log(Level.ERROR, "A critical NPE error occured during while handling a MPBasic Tools packet Client side", (Throwable)new NullPointerException());
                return null;
            }
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (InfoPanelConfigHandler.PAGES.containsKey(message.infopanelPage)) {
                        GuiScreenOverlay.queue.add((GuiScreen)new GuiInfoPanel(null, InfoPanelConfigHandler.PAGES.get(message.infopanelPage), message.hasSeenPage));
                    }
                }
            });
            return null;
        }
    }
}

