/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mpbasic.client;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public class GuiTextArea
extends Gui {
    private final FontRenderer fontRenderObj;
    public String text = "";
    int listScroll = 0;
    int rows = 0;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private boolean isEnabled = true;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    private int lineScrollOffset;
    private int cursorPosition;
    private int cursorCounter;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private boolean visible = true;
    int currentLine = 1;

    public GuiTextArea(FontRenderer fontRendererObj, int x, int y, int w, int h) {
        this.fontRenderObj = fontRendererObj;
        this.xPosition = x;
        this.yPosition = y;
        this.width = w;
        this.height = h;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void moveCursorBy(int p_146182_1_) {
        this.setCursorPosition(this.cursorPosition + p_146182_1_);
    }

    public void setCursorPosition(int p_146190_1_) {
        this.cursorPosition = p_146190_1_;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setSelectionPos(int p_146199_1_) {
        int j = this.text.length();
        if (p_146199_1_ > j) {
            p_146199_1_ = j;
        }
        if (p_146199_1_ < 0) {
            p_146199_1_ = 0;
        }
    }

    public void deleteFromCursor(int p_146175_1_) {
        if (this.text.length() != 0) {
            boolean flag = p_146175_1_ < 0;
            int j = flag ? this.cursorPosition + p_146175_1_ : this.cursorPosition;
            int k = flag ? this.cursorPosition : this.cursorPosition + p_146175_1_;
            String s = "";
            if (j >= 0) {
                s = this.text.substring(0, j);
            }
            if (k < this.text.length()) {
                s = s + this.text.substring(k);
            }
            this.text = s;
            if (flag) {
                this.moveCursorBy(p_146175_1_);
            }
        }
    }

    public void keyTyped(char p_146201_1_, int p_146201_2_) {
        if (!this.isFocused) {
            return;
        }
        switch (p_146201_1_) {
            case '\u0001': {
                this.setCursorPositionEnd();
                this.setSelectionPos(0);
                return;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                return;
            }
        }
        switch (p_146201_2_) {
            case 14: {
                this.deleteFromCursor(-1);
                return;
            }
            case 28: 
            case 156: {
                this.writeText("\n");
                return;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return;
            }
            case 203: {
                this.moveCursorBy(-1);
                return;
            }
            case 205: {
                this.moveCursorBy(1);
                return;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return;
            }
            case 211: {
                this.deleteFromCursor(1);
                return;
            }
        }
        this.writeText(ChatAllowedCharacters.func_71565_a((String)Character.toString(p_146201_1_)));
    }

    public void setText(String p_146180_1_) {
        this.text = p_146180_1_;
        this.setCursorPositionEnd();
    }

    public void writeText(String raw) {
        if (this.rows > this.getMaxRows()) {
            return;
        }
        String s1 = "";
        String s2 = raw;
        int i = this.cursorPosition;
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        s1 = s1 + s2;
        int l = s2.length();
        if (this.text.length() > 0 && i < this.text.length()) {
            s1 = s1 + this.text.substring(i);
        }
        this.text = s1;
        this.moveCursorBy(l);
    }

    public void mouseClicked(int p_146192_1_, int p_146192_2_, int p_146192_3_) {
        boolean flag;
        boolean bl = flag = p_146192_1_ >= this.xPosition && p_146192_1_ < this.xPosition + this.width && p_146192_2_ >= this.yPosition && p_146192_2_ < this.yPosition + this.height;
        if (this.canLoseFocus) {
            this.setFocused(flag);
        }
    }

    public void setFocused(boolean p_146195_1_) {
        if (p_146195_1_ && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = p_146195_1_;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setEnabled(boolean p_146184_1_) {
        this.isEnabled = p_146184_1_;
    }

    public int getWidth() {
        return this.width;
    }

    public String getText() {
        return this.text;
    }

    public void moveLine(int value) {
    }

    public void setLinePosEnd() {
    }

    public void drawTextBox() {
        if (this.getVisible()) {
            GuiTextArea.func_73734_a((int)(this.xPosition - 1), (int)(this.yPosition - 1), (int)(this.xPosition + this.width + 1), (int)(this.yPosition + this.height + 1), (int)-6250336);
            GuiTextArea.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)-16777216);
            int i = this.isEnabled ? this.enabledColor : this.disabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            List s = this.fontRenderObj.func_78271_c(this.getText(), this.getWidth());
            boolean flag = j >= 0 && j <= this.getText().length();
            boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
            this.rows = s.size();
            int l = this.xPosition;
            int i1 = this.yPosition;
            int j1 = l;
            boolean flag2 = this.cursorPosition < this.text.length();
            int k1 = j1;
            boolean lineRow = true;
            int row = 0;
            int charCnt = 0;
            int cursorY = this.yPosition;
            boolean cursorFlag = false;
            for (String line : s) {
                i1 = this.yPosition + row * this.fontRenderObj.field_78288_b;
                k1 = this.fontRenderObj.func_78276_b(line, this.xPosition, i1, Color.white.getRGB());
                if (this.cursorPosition >= charCnt && this.cursorPosition <= charCnt + line.length()) {
                    int charWidth = this.cursorPosition - charCnt < 0 ? 0 : this.cursorPosition - charCnt;
                    k1 = this.xPosition + this.fontRenderObj.func_78256_a(line.substring(0, charWidth));
                    cursorY = this.yPosition + row * this.fontRenderObj.field_78288_b;
                    cursorFlag = true;
                } else if (!cursorFlag) {
                    cursorY = i1;
                }
                charCnt += line.length();
                ++row;
            }
            if (flag1) {
                if (flag2) {
                    Gui.func_73734_a((int)k1, (int)(cursorY - 1), (int)(k1 + 1), (int)(cursorY + 1 + this.fontRenderObj.field_78288_b), (int)-3092272);
                } else {
                    this.fontRenderObj.func_175063_a("_", (float)k1, (float)cursorY, i);
                }
            }
        }
    }

    private void drawCursorVertical(int startX, int startY, int endX, int endY) {
        int i1;
        if (startX < endX) {
            i1 = startX;
            startX = endX;
            endX = i1;
        }
        if (startY < endY) {
            i1 = startY;
            startY = endY;
            endY = i1;
        }
        if (endX > this.xPosition + this.width) {
            endX = this.xPosition + this.width;
        }
        if (startX > this.xPosition + this.width) {
            startX = this.xPosition + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean p_146189_1_) {
        this.visible = p_146189_1_;
    }

    public int getMaxRows() {
        return this.height / this.fontRenderObj.field_78288_b;
    }
}

