/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.gui;

import com.valkyrieofnight.sg.base.ISGNamespace;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBase;
import com.valkyrieofnight.vlib.core.util.client.ColorUtil;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGuiContainer;
import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGuiResources;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElementLevelVert;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElementSlotsArray;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElementText;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.sizablebox.VLElementGuiSizableBox;
import com.valkyrieofnight.vliblegacy.lib.inventory.VLContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class GuiGenBase
extends VLGuiContainer
implements ISGNamespace {
    protected TileGenBase teBase;
    protected EntityPlayer player;
    protected VLElementGuiSizableBox bg;
    protected VLElementLevelVert fuelBuffer;
    protected VLElementLevelVert energyLevel;

    public GuiGenBase(EntityPlayer player, VLContainer inventorySlots, TileGenBase teBase) {
        super(player, inventorySlots);
        this.player = player;
        this.teBase = teBase;
        this.func_183500_a(176, 180);
        this.bg = new VLElementGuiSizableBox("background", VLGuiResources.GUI_STYLE_3);
        this.addElement((VLElement)this.bg);
        VLElementText et = new VLElementText("title", this.getXSize() / 2, 4, ColorUtil.RED + teBase.func_145838_q().func_149732_F());
        this.addElement((VLElement)et);
        et.setHorizontalAlignment(VLElement.HAlignment.CENTER);
        this.addElement((VLElement)new VLElementSlotsArray("mods_slots", VLGuiResources.SLOT_STYLE_3));
        this.fuelBuffer = new VLElementLevelVert("fuel_buffer", 119, 16, VLGuiResources.PROGRESS_OVERLAY_1);
        this.addElement((VLElement)this.fuelBuffer);
        this.energyLevel = new VLElementLevelVert("energy_level", 133, 16, VLGuiResources.ENERGY_OVERLAY_1);
        this.addElement((VLElement)this.energyLevel);
        this.fuelBuffer.updateLevel(1.0f);
    }

    public void update() {
        super.update();
        this.energyLevel.updateLevel(this.teBase.getEnergyLevelScale());
        ArrayList<String> energyLevelTT = new ArrayList<String>();
        energyLevelTT.add(ColorUtil.BLUE + LangUtil.toLoc((String)"gui.simplegenerators.energy"));
        energyLevelTT.add(ColorUtil.GOLD + LangUtil.toLoc((String)"gui.simplegenerators.capacity") + ": " + ColorUtil.RED + String.format("%,d", this.teBase.getEBuffer().getMaxEnergyStored()));
        energyLevelTT.add(ColorUtil.GOLD + LangUtil.toLoc((String)"gui.simplegenerators.stored") + ": " + ColorUtil.RED + String.format("%,d", this.teBase.getEBuffer().getEnergyStored()));
        this.energyLevel.setToolTipList(energyLevelTT);
        this.fuelBuffer.updateLevel(1.0f - this.teBase.getFuelBufferScale());
        int rgb = (int)(255.0f * (1.0f - this.teBase.getFuelBufferScale()));
        this.fuelBuffer.setColor(ColorUtil.calcMCColor((int)(255 - rgb), (int)rgb, (int)0, (int)255));
        ArrayList<String> fuelBufferTT = new ArrayList<String>();
        fuelBufferTT.add(ColorUtil.BLUE + LangUtil.toLoc((String)"gui.simplegenerators.fuelbuffer"));
        fuelBufferTT.add(ColorUtil.GOLD + LangUtil.toLoc((String)"gui.simplegenerators.fuelbufferlevel") + ": " + ColorUtil.RED + String.format("%,d", this.teBase.getTracker().getTocksTotal()));
        fuelBufferTT.add(ColorUtil.GOLD + LangUtil.toLoc((String)"gui.simplegenerators.fuelbufferconsumed") + ": " + ColorUtil.RED + String.format("%,d", this.teBase.getTracker().getTocksComplete()));
        this.fuelBuffer.setToolTipList(fuelBufferTT);
    }

    protected void func_146976_a(float partialTicks, int mx, int my) {
        super.func_146976_a(partialTicks, mx, my);
    }

    protected boolean enableJEIButton() {
        return true;
    }

    protected void addInfo(List<String> toolTips) {
    }
}

