/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.google.common.base.Optional;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.item.ItemWirelessCraftingMonitor;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.WirelessCraftingMonitor;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageWirelessCraftingMonitorSettings
extends MessageHandlerPlayerToServer<MessageWirelessCraftingMonitorSettings>
implements IMessage {
    private Optional<UUID> tabSelected = Optional.absent();
    private int tabPage;

    public MessageWirelessCraftingMonitorSettings() {
    }

    public MessageWirelessCraftingMonitorSettings(Optional<UUID> tabSelected, int tabPage) {
        this.tabSelected = tabSelected;
        this.tabPage = tabPage;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.tabSelected = Optional.of((Object)UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }
        this.tabPage = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.tabSelected.isPresent());
        if (this.tabSelected.isPresent()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((UUID)this.tabSelected.get()).toString());
        }
        buf.writeInt(this.tabPage);
    }

    @Override
    public void handle(MessageWirelessCraftingMonitorSettings message, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerCraftingMonitor) {
            ItemStack stack = ((WirelessCraftingMonitor)((ContainerCraftingMonitor)player.field_71070_bA).getCraftingMonitor()).getStack();
            ItemWirelessCraftingMonitor.setTabPage(stack, message.tabPage);
            ItemWirelessCraftingMonitor.setTabSelected(stack, message.tabSelected);
        }
    }
}

