/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.ItemCover;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTraceResult;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTracer;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrench
extends ItemBase {
    public ItemWrench() {
        super(new ItemInfo("refinedstorage", "wrench"));
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileNode && ((NetworkNode)((TileNode)tile).getNode()).getNetwork() != null && !((NetworkNode)((TileNode)tile).getNode()).getNetwork().getSecurityManager().hasPermission(Permission.BUILD, player)) {
            WorldUtils.sendNoPermissionMessage(player);
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockCable && tile instanceof TileNode && ((TileNode)tile).getNode() instanceof ICoverable) {
            EnumFacing facingSelected;
            CoverManager manager = ((ICoverable)((Object)((TileNode)tile).getNode())).getCoverManager();
            AdvancedRayTraceResult<RayTraceResult> result = AdvancedRayTracer.rayTrace(pos, AdvancedRayTracer.getStart(player), AdvancedRayTracer.getEnd(player), ((BlockCable)block).getCollisions(tile, block.func_176221_a(state, (IBlockAccess)world, pos)));
            if (result != null && result.getGroup().getDirection() != null && manager.hasCover(facingSelected = result.getGroup().getDirection())) {
                ItemStack cover = manager.getCover(facingSelected).getType().createStack();
                ItemCover.setItem(cover, manager.getCover(facingSelected).getStack());
                manager.setCover(facingSelected, null);
                WorldUtils.updateBlock(world, pos);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)cover);
                return EnumActionResult.SUCCESS;
            }
        }
        block.rotateBlock(world, pos, player.func_174811_aO().func_176734_d());
        return EnumActionResult.SUCCESS;
    }
}

