/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemUpgrade;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ItemHandlerUpgrade
extends ItemHandlerBase {
    public ItemHandlerUpgrade(int size, @Nullable Consumer<Integer> listener, int ... supportedUpgrades) {
        super(size, listener, new ItemValidatorBasic[supportedUpgrades.length]);
        for (int i = 0; i < supportedUpgrades.length; ++i) {
            this.validators[i] = new ItemValidatorBasic(RSItems.UPGRADE, supportedUpgrades[i]);
        }
    }

    public int getSpeed() {
        return this.getSpeed(9, 2);
    }

    public int getSpeed(int speed, int speedIncrease) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b() || this.getStackInSlot(i).func_77952_i() != 2) continue;
            speed -= speedIncrease;
        }
        return speed;
    }

    public boolean hasUpgrade(int type) {
        return this.getUpgradeCount(type) > 0;
    }

    public int getUpgradeCount(int type) {
        int upgrades = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b() || this.getStackInSlot(i).func_77952_i() != type) continue;
            ++upgrades;
        }
        return upgrades;
    }

    public int getEnergyUsage() {
        int usage = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            usage += ItemUpgrade.getEnergyUsage(this.getStackInSlot(i));
        }
        return usage;
    }

    public int getFortuneLevel() {
        int maxFortune = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            int fortune;
            if (this.getStackInSlot(i).func_190926_b() || (fortune = ItemUpgrade.getFortuneLevel(this.getStackInSlot(i))) <= maxFortune) continue;
            maxFortune = fortune;
        }
        return maxFortune;
    }

    public int getItemInteractCount() {
        return this.hasUpgrade(4) ? 64 : 1;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }
}

