/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.container.ContainerController;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.tile.ClientNode;
import com.raoulvdberge.refinedstorage.tile.TileController;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public class GuiController
extends GuiBase {
    private static final int VISIBLE_ROWS = 2;
    private TileController controller;
    private int barX = 8;
    private int barY = 20;
    private int barWidth = 16;
    private int barHeight = 59;

    public GuiController(ContainerController container, TileController controller) {
        super(container, 176, 181);
        this.controller = controller;
        this.scrollbar = new Scrollbar(157, 20, 12, 59);
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(this, TileController.REDSTONE_MODE));
    }

    @Override
    public void update(int x, int y) {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 2);
            this.scrollbar.setMaxOffset(this.getRows() - 2);
        }
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/controller.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        int barHeightNew = TileController.getEnergyScaled(TileController.ENERGY_STORED.getValue(), TileController.ENERGY_CAPACITY.getValue(), this.barHeight);
        this.drawTexture(x + this.barX, y + this.barY + this.barHeight - barHeightNew, 178, this.barHeight - barHeightNew, this.barWidth, barHeightNew);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiController.t("gui.refinedstorage:controller." + this.controller.getType().getId(), new Object[0]));
        this.drawString(7, 87, GuiController.t("container.inventory", new Object[0]));
        int x = 33;
        int y = 26;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 2 : 0;
        RenderHelper.func_74520_c();
        List<ClientNode> nodes = TileController.NODES.getValue();
        ClientNode nodeHovering = null;
        for (int i = 0; i < 4; ++i) {
            if (slot < nodes.size()) {
                ClientNode node = nodes.get(slot);
                this.drawItem(x, y + 5, node.getStack());
                float scale = this.field_146289_q.func_82883_a() ? 1.0f : 0.5f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(RenderUtils.getOffsetOnScale(x + 1, scale), RenderUtils.getOffsetOnScale(y - 2, scale), this.trimNameIfNeeded(!this.field_146289_q.func_82883_a(), node.getStack().func_82833_r()));
                this.drawString(RenderUtils.getOffsetOnScale(x + 21, scale), RenderUtils.getOffsetOnScale(y + 10, scale), node.getAmount() + "x");
                GlStateManager.func_179121_F();
                if (this.inBounds(x, y, 16, 16, mouseX, mouseY)) {
                    nodeHovering = node;
                }
            }
            if (i == 1) {
                x = 33;
                y += 30;
            } else {
                x += 60;
            }
            ++slot;
        }
        if (nodeHovering != null) {
            this.drawTooltip(mouseX, mouseY, GuiController.t("misc.refinedstorage:energy_usage_minimal", nodeHovering.getEnergyUsage()));
        }
        if (this.inBounds(this.barX, this.barY, this.barWidth, this.barHeight, mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiController.t("misc.refinedstorage:energy_usage", TileController.ENERGY_USAGE.getValue()) + "\n" + GuiController.t("misc.refinedstorage:energy_stored", TileController.ENERGY_STORED.getValue(), TileController.ENERGY_CAPACITY.getValue()));
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)TileController.NODES.getValue().size() / 2.0f));
    }

    private String trimNameIfNeeded(boolean scaled, String name) {
        int max;
        int n = max = scaled ? 20 : 13;
        if (name.length() > max) {
            name = name.substring(0, max) + "...";
        }
        return name;
    }
}

