/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridCraftingListener;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilter;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.container.slot.grid.SlotGridCrafting;
import com.raoulvdberge.refinedstorage.container.slot.grid.SlotGridCraftingResult;
import com.raoulvdberge.refinedstorage.container.slot.legacy.SlotLegacyBase;
import com.raoulvdberge.refinedstorage.container.slot.legacy.SlotLegacyDisabled;
import com.raoulvdberge.refinedstorage.container.slot.legacy.SlotLegacyFilter;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerGrid
extends ContainerBase
implements IGridCraftingListener {
    private IGrid grid;
    private IStorageCache cache;
    private IStorageCacheListener listener;
    private IResizableDisplay display;
    private SlotGridCraftingResult craftingResultSlot;
    private SlotLegacyBase patternResultSlot;

    public ContainerGrid(IGrid grid, IResizableDisplay display, @Nullable TileBase gridTile, EntityPlayer player) {
        super(gridTile, player);
        this.grid = grid;
        this.display = display;
        this.initSlots();
        grid.addCraftingListener(this);
    }

    public void initSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.transferManager.clearTransfers();
        this.addFilterSlots();
        if (this.grid instanceof IPortableGrid) {
            this.addPortableGridSlots();
        }
        if (this.grid.getGridType() == GridType.CRAFTING) {
            this.addCraftingSlots();
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            this.addPatternSlots();
        }
        this.transferManager.setNotFoundHandler(slotIndex -> {
            Slot slot;
            if (!this.getPlayer().func_130014_f_().field_72995_K && (slot = (Slot)this.field_75151_b.get((int)slotIndex)).func_75216_d()) {
                if (slot == this.craftingResultSlot) {
                    this.grid.onCraftedShift(this.getPlayer());
                    this.func_75142_b();
                } else {
                    ItemStack stack = slot.func_75211_c();
                    if (this.grid.getGridType() == GridType.FLUID) {
                        IFluidGridHandler fluidHandler = this.grid.getFluidHandler();
                        if (fluidHandler != null) {
                            slot.func_75215_d(fluidHandler.onShiftClick((EntityPlayerMP)this.getPlayer(), stack));
                        }
                    } else {
                        IItemGridHandler itemHandler = this.grid.getItemHandler();
                        if (itemHandler != null) {
                            slot.func_75215_d(itemHandler.onShiftClick((EntityPlayerMP)this.getPlayer(), stack));
                        } else if (slot instanceof SlotGridCrafting && this.func_75135_a(stack, 14, 50, false)) {
                            slot.func_75218_e();
                            this.grid.onCraftingMatrixChanged();
                        }
                    }
                    this.func_75142_b();
                }
            }
            return ItemStack.field_190927_a;
        });
        this.addPlayerInventory(8, this.display.getYPlayerInventory());
    }

    private void addPortableGridSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)((IPortableGrid)((Object)this.grid)).getDisk(), 0, 204, 6));
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)((IPortableGrid)((Object)this.grid)).getDisk());
    }

    private void addFilterSlots() {
        int yStart = 6;
        if (this.grid instanceof IPortableGrid) {
            yStart = 38;
        }
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.grid.getFilter(), i, 204, yStart + 18 * i));
        }
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)this.grid.getFilter());
    }

    private void addCraftingSlots() {
        int headerAndSlots = this.display.getTopHeight() + this.display.getVisibleRows() * 18;
        int x = 26;
        int y = headerAndSlots + 4;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotGridCrafting((IInventory)this.grid.getCraftingMatrix(), i, x, y));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            y += 18;
            x = 26;
        }
        this.craftingResultSlot = new SlotGridCraftingResult(this, this.getPlayer(), this.grid, 0, 134, headerAndSlots + 22);
        this.func_75146_a((Slot)this.craftingResultSlot);
    }

    private void addPatternSlots() {
        int i;
        int ox;
        int headerAndSlots = this.display.getTopHeight() + this.display.getVisibleRows() * 18;
        this.func_75146_a((Slot)new SlotItemHandler(((NetworkNodeGrid)this.grid).getPatterns(), 0, 172, headerAndSlots + 4));
        this.func_75146_a((Slot)new SlotItemHandler(((NetworkNodeGrid)this.grid).getPatterns(), 1, 172, headerAndSlots + 40));
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, ((NetworkNodeGrid)this.grid).getPatterns());
        int x = ox = 8;
        int y = headerAndSlots + 4;
        for (i = 0; i < 18; ++i) {
            this.func_75146_a((Slot)new SlotFilter((IItemHandler)((NetworkNodeGrid)this.grid).getProcessingMatrix(), i, x, y, 1).setEnableHandler(() -> ((NetworkNodeGrid)this.grid).isProcessingPattern() && ((NetworkNodeGrid)this.grid).getType() == 0));
            this.func_75146_a((Slot)new SlotFilterFluid(((NetworkNodeGrid)this.grid).getProcessingMatrixFluids(), i, x, y, 1).setEnableHandler(() -> ((NetworkNodeGrid)this.grid).isProcessingPattern() && ((NetworkNodeGrid)this.grid).getType() == 1));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            if (i == 8) {
                x = ox = 98;
                y = headerAndSlots + 4;
                continue;
            }
            x = ox;
            y += 18;
        }
        x = 26;
        y = headerAndSlots + 4;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotLegacyFilter((IInventory)this.grid.getCraftingMatrix(), i, x, y).setEnableHandler(() -> !((NetworkNodeGrid)this.grid).isProcessingPattern()));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            y += 18;
            x = 26;
        }
        this.patternResultSlot = new SlotLegacyDisabled((IInventory)this.grid.getCraftingResult(), 0, 134, headerAndSlots + 22).setEnableHandler(() -> !((NetworkNodeGrid)this.grid).isProcessingPattern());
        this.func_75146_a(this.patternResultSlot);
    }

    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public void onCraftingMatrixChanged() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotGridCrafting) && slot != this.craftingResultSlot && slot != this.patternResultSlot) continue;
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, i, slot.func_75211_c()));
            }
        }
    }

    @Override
    public void func_75142_b() {
        if (!this.getPlayer().field_70170_p.field_72995_K) {
            if (this.grid.getStorageCache() == null) {
                if (this.listener != null) {
                    this.cache.removeListener(this.listener);
                    this.listener = null;
                    this.cache = null;
                }
            } else if (this.listener == null) {
                this.listener = this.grid.createListener((EntityPlayerMP)this.getPlayer());
                this.cache = this.grid.getStorageCache();
                this.cache.addListener(this.listener);
            }
        }
        super.func_75142_b();
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K) {
            this.grid.onClosed(player);
            if (this.cache != null && this.listener != null) {
                this.cache.removeListener(this.listener);
            }
        }
        this.grid.removeCraftingListener(this);
    }

    @Override
    public boolean func_94530_a(ItemStack stack, Slot slot) {
        if (slot == this.craftingResultSlot || slot == this.patternResultSlot) {
            return false;
        }
        return super.func_94530_a(stack, slot);
    }

    @Override
    protected int getDisabledSlotNumber() {
        return this.grid.getSlotId();
    }
}

