/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeWriter;
import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.CollisionGroup;
import com.raoulvdberge.refinedstorage.tile.TileWriter;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWriter
extends BlockCable {
    public BlockWriter() {
        super(BlockWriter.createBuilder("writer").tileEntity(TileWriter::new).create());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "connected=false,direction=north,down=false,east=true,north=false,south=false,up=false,west=true"));
        this.registerCoverAndFullbright(modelRegistration, "refinedstorage:blocks/writer/cutouts/connected");
    }

    @Override
    @Nullable
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    public List<CollisionGroup> getCollisions(TileEntity tile, IBlockState state) {
        return RSBlocks.CONSTRUCTOR.getCollisions(tile, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.canAccessGui(state, world, pos, hitX, hitY, hitZ)) {
            return false;
        }
        if (!world.field_72995_K) {
            NetworkNodeWriter writer = (NetworkNodeWriter)((TileWriter)world.func_175625_s(pos)).getNode();
            if (player.func_70093_af()) {
                IReaderWriterChannel channel;
                if (writer.getNetwork() != null && (channel = writer.getNetwork().getReaderWriterManager().getChannel(writer.getChannel())) != null) {
                    channel.getHandlers().stream().map(h -> h.getStatusWriter(writer, channel)).flatMap(Collection::stream).forEach(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                }
            } else {
                this.openNetworkGui(20, player, world, pos, side);
            }
        }
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IWriter writer = (IWriter)((TileWriter)world.func_175625_s(pos)).getNode();
        return side == writer.getDirection().func_176734_d() ? writer.getRedstoneStrength() : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileWriter && side == ((TileWriter)tile).getDirection().func_176734_d();
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

