/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview;

import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class CraftingPreviewElementError
implements ICraftingPreviewElement<ItemStack> {
    public static final String ID = "error";
    private CraftingTaskErrorType type;
    private ItemStack stack;

    public CraftingPreviewElementError(CraftingTaskErrorType type, ItemStack stack) {
        this.type = type;
        this.stack = stack;
    }

    @Override
    public ItemStack getElement() {
        return this.stack;
    }

    @Override
    public void draw(int x, int y, IElementDrawers drawers) {
    }

    @Override
    public int getAvailable() {
        return 0;
    }

    @Override
    public int getToCraft() {
        return 0;
    }

    @Override
    public boolean hasMissing() {
        return false;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(Item.func_150891_b((Item)this.stack.func_77973_b()));
        buf.writeInt(this.stack.func_77960_j());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.func_77978_p());
    }

    public CraftingTaskErrorType getType() {
        return this.type;
    }

    public static CraftingPreviewElementError fromByteBuf(ByteBuf buf) {
        int errorIdx = buf.readInt();
        CraftingTaskErrorType error = errorIdx >= 0 && errorIdx < CraftingTaskErrorType.values().length ? CraftingTaskErrorType.values()[errorIdx] : CraftingTaskErrorType.TOO_COMPLEX;
        Item item = Item.func_150899_d((int)buf.readInt());
        int meta = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        ItemStack stack = new ItemStack(item, 1, meta);
        stack.func_77982_d(tag);
        return new CraftingPreviewElementError(error, stack);
    }

    @Override
    public String getId() {
        return ID;
    }
}

