/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.playerskins.handlers;

import com.gendeathrow.playerskins.core.ConfigHandler;
import com.gendeathrow.playerskins.core.PlayerSkinsCore;
import com.gendeathrow.playerskins.data.LootItem;
import com.gendeathrow.playerskins.data.PlayerSkinData;
import com.gendeathrow.playerskins.handlers.SpecialLootManager;
import com.gendeathrow.playerskins.utils.Tools;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber
public class PlayerManager {
    public static final HashMap<String, PlayerSkinData> playersList = new HashMap();
    public static final File playerSkinFile = new File(ConfigHandler.configDir, "skins.json");
    public static final File whiteListFolder = new File("playerskinsWhitelist");
    public static final Random rand = new Random();
    private static boolean markDirty = false;

    public static void markDirty() {
        markDirty = true;
    }

    @SubscribeEvent
    public static void WorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        PlayerManager.Save();
    }

    public static PlayerSkinData getRandomPlayerSkin() {
        return (PlayerSkinData)WeightedRandom.func_76271_a((Random)rand, PlayerManager.getWeightedList());
    }

    private static List<PlayerSkinData> getWeightedList() {
        return Lists.newArrayList(playersList.values());
    }

    public static GameProfile getAddPlayerSkinProfile(String ownerName) {
        if (playersList.containsKey(ownerName)) {
            return playersList.get(ownerName).getProfile();
        }
        playersList.put(ownerName, new PlayerSkinData(new GameProfile(null, ownerName), 10));
        return playersList.get(ownerName).getProfile();
    }

    public static PlayerSkinData getPlayerSkinProfile(String ownerName) {
        return playersList.get(ownerName);
    }

    public static PlayerSkinData getPlayerSkinProfile(GameProfile playerProfile) {
        return playersList.get(playerProfile.getName());
    }

    public static HashMap<String, PlayerSkinData> getAllRaiders() {
        return playersList;
    }

    public static void setPlayerSkinProfile(String ownerName, GameProfile newProfile) {
        if (playersList.containsKey(ownerName)) {
            playersList.get(ownerName).setProfile(newProfile);
        }
    }

    public static void addNewPlayerSkin(String ownerName, int weight) {
        if (!playersList.containsKey(ownerName)) {
            playersList.put(ownerName, new PlayerSkinData(new GameProfile(null, ownerName), weight));
            markDirty = true;
        }
    }

    private static void addNewPlayer(String ownerName, int weight) {
        PlayerManager.addNewPlayer(ownerName, weight, null);
    }

    private static void addNewPlayer(String ownerName, int weight, ItemStack ... stacks) {
        if (!playersList.containsKey(ownerName)) {
            PlayerSkinData playerskin = new PlayerSkinData(new GameProfile(null, ownerName), weight);
            playersList.put(ownerName, playerskin);
            ArrayList<LootItem> drops = new ArrayList<LootItem>();
            if (stacks != null) {
                for (ItemStack stack : stacks) {
                    if (stack == null || stack.func_190926_b()) continue;
                    drops.add(new LootItem(stack));
                }
            }
            if (!drops.isEmpty()) {
                SpecialLootManager.addNewSpecial(playerskin, drops);
            }
        }
    }

    public static void removePlayerSkin(String ownerName) {
        playersList.remove(ownerName);
        markDirty = true;
    }

    public static void Save() {
        if (markDirty) {
            PlayerManager.savePlayerSkinFile();
            markDirty = false;
        }
    }

    public static void readPlayerSkinFile() {
        PlayerManager.getTwitchSubscribers();
        if (playerSkinFile.isFile()) {
            try {
                playersList.clear();
                SpecialLootManager.clearLootTable();
                playersList.putAll(PlayerManager.parseJson(FileUtils.readFileToString((File)playerSkinFile)));
                PlayerManager.getTwitchSubscribers();
            }
            catch (IOException ioexception) {
                PlayerSkinsCore.logger.error("Couldn't read Player Skins file " + playerSkinFile, (Throwable)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                PlayerSkinsCore.logger.error("Couldn't parse Player Skin file " + playerSkinFile, (Throwable)jsonparseexception);
            }
        } else {
            PlayerManager.loadDefaults();
            PlayerManager.savePlayerSkinFile();
        }
    }

    public static void savePlayerSkinFile() {
        FileOutputStream fo = null;
        try {
            fo = FileUtils.openOutputStream((File)playerSkinFile);
            String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)PlayerManager.dumpJson(playersList));
            FileUtils.writeStringToFile((File)playerSkinFile, (String)json);
            fo.close();
        }
        catch (IOException ioexception) {
            PlayerSkinsCore.logger.error("Couldn't save stats", (Throwable)ioexception);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fo);
        }
    }

    public static Map<String, PlayerSkinData> parseJson(String p_150881_1_) {
        JsonElement jsonelement = new JsonParser().parse(p_150881_1_);
        if (!jsonelement.isJsonObject()) {
            return Maps.newHashMap();
        }
        JsonObject jsonobject = jsonelement.getAsJsonObject();
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonobject.entrySet()) {
            String playerOwner = (String)entry.getKey();
            if (playerOwner != null) {
                JsonObject playerJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                int weight = 10;
                Object uuid = null;
                if (playerJson.has("weight")) {
                    weight = playerJson.get("weight").getAsInt();
                }
                playerJson.remove("uuid");
                GameProfile playerProfile = new GameProfile(null, playerOwner);
                PlayerSkinData skinData = new PlayerSkinData(playerProfile, weight);
                if (!map.containsKey(playerOwner)) {
                    map.put(playerOwner, skinData);
                    SpecialLootManager.readJsonItemDrops(skinData, playerJson);
                    continue;
                }
                PlayerSkinsCore.logger.warn("Player Skin already exist in " + playerSkinFile + ":" + (String)entry.getKey());
                continue;
            }
            PlayerSkinsCore.logger.warn("Invalid Player Skin in " + playerSkinFile + ": Don't know what " + (String)entry.getKey() + " is");
        }
        return map;
    }

    public static JsonObject dumpJson(Map<String, PlayerSkinData> p_150880_0_) {
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry<String, PlayerSkinData> entry : p_150880_0_.entrySet()) {
            if (entry.getValue() != null) {
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("weight", (Number)entry.getValue().field_76292_a);
                SpecialLootManager.writeJsonItemDrops(entry.getValue(), jsonobject1);
                jsonobject.add(entry.getKey(), (JsonElement)jsonobject1);
                continue;
            }
            jsonobject.addProperty(entry.getKey(), (Number)10);
        }
        return jsonobject;
    }

    public static void getTwitchSubscribers() {
        PlayerManager.getTwitchSubscribers(false);
    }

    public static void getTwitchSubscribers(boolean force) {
        whiteListFolder.mkdirs();
        for (String list : ConfigHandler.whitelists) {
            File subs = new File(whiteListFolder, list.replaceAll("\\W+", "") + ".txt");
            if (!subs.exists() || force) {
                try {
                    Tools.DownloadFile(list, subs.getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!subs.exists()) continue;
            try {
                PlayerManager.parseTwitchSubsWhiteList(subs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void parseTwitchSubsWhiteList(File file) throws IOException {
        FileReader input = new FileReader(file);
        BufferedReader bufRead = new BufferedReader(input);
        String myLine = null;
        try {
            while ((myLine = bufRead.readLine()) != null) {
                String[] array2 = myLine.split("\n");
                for (int i = 0; i < array2.length; ++i) {
                    PlayerManager.addNewPlayerSkin(array2[i], 10);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ItemStack addLore(ItemStack stack, String ... strings) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound lore = new NBTTagCompound();
        NBTTagList lore2 = new NBTTagList();
        for (String string : strings) {
            lore2.func_74742_a((NBTBase)new NBTTagString(string));
        }
        lore.func_74782_a("Lore", (NBTBase)lore2);
        stack.func_77978_p().func_74782_a("display", (NBTBase)lore);
        return stack;
    }

    public static void loadDefaults() {
        PlayerManager.addNewPlayer("Gen_Deathrow", 10, PlayerManager.addLore(new ItemStack(Items.field_151106_aX), "Here have a cookie for your troubles.", "Your Friend,", "   GenDeathrow"));
        PlayerManager.addNewPlayer("Funwayguy", 10);
        PlayerManager.addNewPlayer("Kashdeya", 10);
        PlayerManager.addNewPlayer("TheMattaBase", 10);
        PlayerManager.addNewPlayer("Jsl7", 10);
        PlayerManager.addNewPlayer("Turkey2349", 10);
        PlayerManager.addNewPlayer("GWSheridan", 10);
        PlayerManager.addNewPlayer("DatFailGamur", 10);
        PlayerManager.addNewPlayer("darkphan", 10);
        PlayerManager.addNewPlayer("SinfulDeity", 10);
        PlayerManager.addNewPlayer("Bacon_Donut", 10);
        PlayerManager.addNewPlayer("SlothMonster_", 10);
        PlayerManager.addNewPlayer("Gooderness", 10);
        PlayerManager.addNewPlayer("Vash505", 10);
        PlayerManager.addNewPlayer("Darkosto", 10, new ItemStack(Items.field_151055_y).func_151001_c("Builders Wand"));
        PlayerManager.addNewPlayer("Sevadus", 10);
        PlayerManager.addNewPlayer("CrustyMustard", 10);
        PlayerManager.addNewPlayer("Wyld", 10);
        PlayerManager.addNewPlayer("GiantWaffle", 10);
        PlayerManager.addNewPlayer("Soaryn", 10);
        PlayerManager.addNewPlayer("ZeldoKavira", 10);
        PlayerManager.addNewPlayer("LexManos", 10);
        PlayerManager.addNewPlayer("cpw11", 10);
        PlayerManager.addNewPlayer("ganymedes01", 10);
        PlayerManager.addNewPlayer("iChun", 10);
        PlayerManager.addNewPlayer("KingLemming", 10);
        PlayerManager.addNewPlayer("ProfMobius", 10);
        PlayerManager.addNewPlayer("Sacheverell", 10);
        PlayerManager.addNewPlayer("Pahimar", 10);
        PlayerManager.addNewPlayer("Vazkii", 10);
        PlayerManager.addNewPlayer("FatherToast", 10);
        PlayerManager.addNewPlayer("vadis365", 10);
        PlayerManager.addNewPlayer("PurpleMentat", 10);
        PlayerManager.addNewPlayer("direwolf20", 10);
        PlayerManager.addNewPlayer("ChimneySwift", 10);
        PlayerManager.addNewPlayer("Sjin", 10);
        PlayerManager.addNewPlayer("Xephos", 10);
        PlayerManager.addNewPlayer("CaptainSparklez", 10);
        PlayerManager.addNewPlayer("DanTDM", 10);
        PlayerManager.addNewPlayer("Etho", 10);
        PlayerManager.addNewPlayer("SethBling", 10);
        PlayerManager.addNewPlayer("WayofFlowingTime", 10);
        PlayerManager.addNewPlayer("Kehaan", 10);
        PlayerManager.addNewPlayer("tfox83", 10);
        PlayerManager.addNewPlayer("slowpoke101", 10);
        PlayerManager.addNewPlayer("Notch", 10);
        PlayerManager.addNewPlayer("jeb_", 10);
        PlayerManager.addNewPlayer("EvilSeph", 10);
        PlayerManager.addNewPlayer("C418", 10);
        PlayerManager.addNewPlayer("Dinnerbone", 10);
        PlayerManager.addNewPlayer("carnalizer", 10);
        PlayerManager.addNewPlayer("Grumm", 10);
        PlayerManager.addNewPlayer("Searge_DP", 10);
        PlayerManager.addNewPlayer("TheMogMiner", 10);
    }
}

