/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.playerskins.entity;

import com.gendeathrow.playerskins.client.PlayerSkinManager;
import com.gendeathrow.playerskins.core.ConfigHandler;
import com.gendeathrow.playerskins.core.init.RegisterEntities;
import com.gendeathrow.playerskins.data.PlayerSkinData;
import com.gendeathrow.playerskins.handlers.PlayerManager;
import com.gendeathrow.playerskins.handlers.SpecialLootManager;
import com.mojang.authlib.GameProfile;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPlayerMob
extends EntityMob {
    protected GameProfile playerProfile;
    public boolean profileset = false;
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9577-4402-BA4F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<String> SKIN_VARIANT = EntityDataManager.func_187226_a(EntityPlayerMob.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private boolean isBreakDoorsTaskSet;
    private float playerWidth = -1.0f;
    private float playerHeight;

    public EntityPlayerMob(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(SKIN_VARIANT, (Object)"Steve");
    }

    public boolean isBreakDoorsTaskSet() {
        return this.isBreakDoorsTaskSet;
    }

    public void setBreakDoorsAItask(boolean enabled) {
        if (this.isBreakDoorsTaskSet != enabled) {
            this.isBreakDoorsTaskSet = enabled;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
            if (enabled) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return RegisterEntities.playerSkinLoot;
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(BABY_SPEED_BOOST);
            if (childZombie) {
                iattributeinstance.func_111121_a(BABY_SPEED_BOOST);
            }
        }
        this.setChildSize(childZombie);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public GameProfile getPlayerProfile() {
        return PlayerManager.getAddPlayerSkinProfile(this.getOwner());
    }

    public ResourceLocation getLocationSkin() {
        return PlayerSkinManager.DownloadPlayersSkin(this);
    }

    public void setOwner(String name) {
        this.field_70180_af.func_187227_b(SKIN_VARIANT, (Object)name);
    }

    public String getOwner() {
        return (String)this.field_70180_af.func_187225_a(SKIN_VARIANT);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        PlayerSkinData skin = EntityPlayerMob.getRandomPlayerSkin();
        this.setOwner(skin.getOwnerName());
        this.func_96094_a(skin.getOwnerName());
        if (livingdata == null) {
            livingdata = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ConfigHandler.childSpawn);
        }
        if (livingdata instanceof GroupData) {
            GroupData entityplayermob$groupdata = (GroupData)livingdata;
            if (entityplayermob$groupdata.isChild) {
                this.setChild(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.func_152117_i(true);
                        this.func_184220_m((Entity)entitychicken);
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken entitychicken1 = new EntityChicken(this.field_70170_p);
                    entitychicken1.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    entitychicken1.func_180482_a(difficulty, (IEntityLivingData)null);
                    entitychicken1.func_152117_i(true);
                    this.field_70170_p.func_72838_d((Entity)entitychicken1);
                    this.func_184220_m((Entity)entitychicken1);
                }
            }
        }
        this.setBreakDoorsAItask(this.field_70146_Z.nextFloat() < f * 0.1f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.setBreakDoorsAItask(true);
        }
        return livingdata;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Owner")) {
            this.setOwner(compound.func_74779_i("Owner"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("Owner", this.getOwner());
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.setBreakDoorsAItask(compound.func_74767_n("CanBreakDoors"));
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        compound.func_74757_a("CanBreakDoors", this.isBreakDoorsTaskSet());
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.playerWidth > 0.0f && this.playerHeight > 0.0f;
        this.playerWidth = width;
        this.playerHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.playerWidth * size, this.playerHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a));
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(stack);
    }

    public void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        double dropit;
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && (dropit = this.field_70146_Z.nextDouble()) < 0.025) {
            ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("SkullOwner", this.getOwner());
            EntityItem skull = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
            this.field_70170_p.func_72838_d((Entity)skull);
        }
        if (SpecialLootManager.hasLoot(this.getOwner())) {
            SpecialLootManager.DropLoot((Entity)this, this.getOwner());
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187800_eb;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected static PlayerSkinData getRandomPlayerSkin() {
        PlayerSkinData profile = PlayerManager.getRandomPlayerSkin();
        return profile;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild;

        private GroupData(boolean p_i47328_2_) {
            this.isChild = p_i47328_2_;
        }
    }
}

