/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.playerskins.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class LootItem {
    private String itemID;
    private int metaID;
    private double chance;
    private int qty;
    private NBTTagCompound nbtData;
    private JsonObject nbtRawJson;
    private boolean isComplete = false;
    private ItemStack stack;
    Gson gson = new Gson();

    public LootItem() {
        this.itemID = Items.field_190931_a.getRegistryName().toString();
        this.metaID = 0;
        this.chance = 0.5;
        this.qty = 1;
        this.nbtData = null;
        this.stack = ItemStack.field_190927_a;
    }

    public LootItem(ItemStack stackIn) {
        this.itemID = stackIn.func_77973_b().getRegistryName().toString();
        this.metaID = stackIn.func_77960_j();
        this.chance = 0.2;
        this.qty = stackIn.func_190916_E();
        this.stack = stackIn;
        this.nbtData = stackIn.func_77942_o() ? stackIn.func_77978_p() : null;
        this.isComplete = true;
    }

    public LootItem(String itemID, int metaID, double chance, int qty) {
        this.itemID = itemID;
        this.metaID = metaID;
        this.chance = chance;
        this.qty = qty;
        this.nbtData = null;
    }

    @Nullable
    public Item getItem() {
        return Item.func_111206_d((String)this.itemID);
    }

    public int getMeta() {
        return this.metaID;
    }

    public boolean shouldDrop(Random rand) {
        return rand.nextDouble() <= this.chance;
    }

    public ItemStack getStack(Random rand) {
        if (!this.isComplete) {
            this.isComplete = true;
            if (this.getItem() != null) {
                this.stack = new ItemStack(this.getItem(), this.qty > 1 ? rand.nextInt(this.qty - 1) + 1 : this.qty, this.metaID);
                if (this.nbtData != null && !this.nbtData.func_82582_d()) {
                    this.stack.func_77982_d(this.nbtData);
                }
                return this.stack.func_77946_l();
            }
        }
        return this.stack.func_77946_l();
    }

    public LootItem readJsonObject(JsonObject data) throws NumberFormatException {
        this.itemID = data.has("itemID") ? data.get("itemID").getAsString() : Items.field_190931_a.getRegistryName().toString();
        this.metaID = data.has("metaID") ? data.get("metaID").getAsInt() : 0;
        this.chance = data.has("chance") ? data.get("chance").getAsDouble() : 0.5;
        this.qty = data.has("qty") ? data.get("qty").getAsInt() : 1;
        this.nbtRawJson = data.has("nbt") ? data.get("nbt").getAsJsonObject() : null;
        try {
            this.nbtData = data.has("nbt") ? JsonToNBT.func_180713_a((String)data.get("nbt").getAsJsonObject().toString()) : null;
        }
        catch (NBTException e) {
            e.printStackTrace();
            this.nbtData = null;
        }
        return this;
    }

    public void writeJsonObject(JsonObject data) throws NumberFormatException {
        data.addProperty("itemID", this.itemID);
        data.addProperty("metaID", (Number)this.metaID);
        data.addProperty("chance", (Number)this.chance);
        data.addProperty("qty", (Number)this.qty);
        if (this.nbtData != null && !this.nbtData.func_82582_d()) {
            JsonElement element = (JsonElement)this.gson.fromJson(this.nbtData.toString(), JsonElement.class);
            data.add("nbt", (JsonElement)element.getAsJsonObject());
        }
    }
}

