/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.playerskins.client;

import com.gendeathrow.playerskins.core.ConfigHandler;
import com.gendeathrow.playerskins.core.PlayerSkinsCore;
import com.gendeathrow.playerskins.data.PlayerSkinData;
import com.gendeathrow.playerskins.entity.EntityPlayerMob;
import com.gendeathrow.playerskins.handlers.PlayerManager;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class PlayerSkinManager {
    public static PlayerProfileCache profileCache;
    public static MinecraftSessionService sessionService;
    public final HashMap<String, ResourceLocation> cachedSkins = new HashMap();
    public static final PlayerSkinManager INSTANCE;
    private static Thread thread2;
    private static List<PlayerSkinData> raidersdata;
    private static List<String> badraiders;

    public static void cacheSkins() {
        Iterator<PlayerSkinData> raidersList = PlayerManager.getAllRaiders().values().iterator();
        while (raidersList.hasNext()) {
            PlayerSkinManager.updateProfile(raidersList.next());
        }
    }

    public static void updateProfile(PlayerSkinData raiderInfo) {
        if (raiderInfo == null) {
            return;
        }
        if (!raidersdata.contains((Object)raiderInfo)) {
            raidersdata.add(raiderInfo);
        }
        if (thread2 == null || thread2.getState() == Thread.State.TERMINATED) {
            thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!raidersdata.isEmpty()) {
                        PlayerSkinData raider = (PlayerSkinData)((Object)raidersdata.get(0));
                        raider.setProfile(TileEntitySkull.func_174884_b((GameProfile)raider.getProfile()));
                        raider.setProfileUpdated();
                        try {
                            Thread.sleep(ConfigHandler.cacheTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        raidersdata.remove(0);
                    }
                }
            });
            thread2.start();
        }
    }

    public static void addToBadList(String owner) {
        if (!badraiders.contains(owner)) {
            badraiders.add(owner);
            PlayerSkinsCore.logger.error("Could not Get this players profile." + owner + " Added to the Naughty List");
        }
    }

    public static ResourceLocation DownloadPlayersSkin(EntityPlayerMob raider) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        PlayerSkinData playerSkinProfile = PlayerManager.getPlayerSkinProfile(raider.getPlayerProfile());
        if (raider.getPlayerProfile() != null && playerSkinProfile != null) {
            if (playerSkinProfile.hasUpdatedProfile()) {
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(raider.getPlayerProfile());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
            } else {
                PlayerSkinManager.updateProfile(playerSkinProfile);
            }
        }
        return resourcelocation;
    }

    static {
        INSTANCE = new PlayerSkinManager();
        raidersdata = new ArrayList<PlayerSkinData>();
        badraiders = new ArrayList<String>();
    }
}

