/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.blocks;

import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.chargers.blocks.BlockEnergy;
import se.gory_moon.chargers.blocks.BlockRegistry;
import se.gory_moon.chargers.items.ItemWirelessChargerBlock;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

public class BlockWirelessCharger
extends BlockEnergy
implements BlockRegistry.ICustomItemBlock {
    public static PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockWirelessCharger() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.setHarvestLevel("pickaxe", 0);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityWirelessCharger) {
            return state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(((TileEntityWirelessCharger)tileEntity).canCharge()));
        }
        return state;
    }

    @Override
    @Nonnull
    public ItemBlock getItemBlock() {
        return new ItemWirelessChargerBlock(this);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityWirelessCharger) {
            if (player.func_70093_af()) {
                return false;
            }
            TileEntityWirelessCharger tile = (TileEntityWirelessCharger)tileEntity;
            boolean powered = ((TileEntityWirelessCharger)tileEntity).isPowered();
            ITextComponent status = new TextComponentTranslation("chat.chargers." + (powered ? "disabled" : "enabled"), new Object[0]).func_150255_a(new Style().func_150238_a(powered ? TextFormatting.RED : TextFormatting.GREEN));
            NumberFormat format = NumberFormat.getInstance();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.chargers.wireless_charger.info", new Object[]{status, format.format(tile.storage.getEnergyStored()), format.format(tile.storage.getMaxEnergyStored())}), true);
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.chargers.wireless_charger", (Object[])new Object[0]));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityWirelessCharger();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }
}

