/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.statement;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IActionInternalSided;
import buildcraft.api.statements.IActionSingle;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.silicon.BCSiliconSprites;
import buildcraft.silicon.BCSiliconStatements;
import buildcraft.silicon.plug.PluggablePulsar;
import net.minecraft.util.EnumFacing;

public class ActionPowerPulsar
extends BCStatement
implements IActionInternalSided,
IActionSingle {
    public final boolean constant;

    public ActionPowerPulsar(boolean constant) {
        super(new String[]{"buildcraft:pulsar." + (constant ? "constant" : "single"), "buildcraft.pulsar.constant" + (constant ? "constant" : "single")});
        this.constant = constant;
    }

    public String getDescription() {
        return LocaleUtil.localize((String)(this.constant ? "gate.action.pulsar.constant" : "gate.action.pulsar.single"));
    }

    public void actionActivate(EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        IGate gate;
        IPipeHolder pipe;
        PipePluggable plug;
        if (source instanceof IGate && (plug = (pipe = (gate = (IGate)source).getPipeHolder()).getPluggable(side)) instanceof PluggablePulsar) {
            PluggablePulsar pulsar = (PluggablePulsar)plug;
            if (this.constant) {
                pulsar.enablePulsar();
            } else {
                pulsar.addSinglePulse();
            }
        }
    }

    public boolean singleActionTick() {
        return !this.constant;
    }

    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return this.constant ? BCSiliconSprites.ACTION_PULSAR_CONSTANT : BCSiliconSprites.ACTION_PULSAR_SINGLE;
    }

    public IStatement[] getPossible() {
        return BCSiliconStatements.ACTION_PULSAR;
    }
}

