/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.recipe;

import buildcraft.api.facades.FacadeAPI;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.IRecipeViewable;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.item.ItemPluggableFacade;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadeStateManager;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public enum FacadeSwapRecipe implements IRecipe,
IRecipeViewable.IViewableGrid
{
    INSTANCE;

    private static final int TIME_GAP = 500;
    private static final ChangingItemStack[] INPUTS;
    private static ChangingItemStack OUTPUTS;

    public static void genRecipes() {
        if (FacadeAPI.facadeItem == null) {
            throw new IllegalStateException("Don't call FacadeSwapRecipe if the facade item doesn't exist!");
        }
        NonNullList list1 = NonNullList.func_191196_a();
        NonNullList list2 = NonNullList.func_191196_a();
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            ItemStack stack = FacadeSwapRecipe.createFacade(info, false);
            ItemStack stackHollow = FacadeSwapRecipe.createFacade(info, true);
            list1.add((Object)stack);
            list1.add((Object)stackHollow);
            list2.add((Object)stackHollow);
            list2.add((Object)stack);
        }
        if (!list1.isEmpty()) {
            FacadeSwapRecipe.INPUTS[0] = new ChangingItemStack(list1);
            INPUTS[0].setTimeGap(500);
            OUTPUTS = new ChangingItemStack(list2);
            OUTPUTS.setTimeGap(500);
        }
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return !this.func_77572_b(inv).func_190926_b();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack stackIn = StackUtil.EMPTY;
        for (int s = 0; s < inv.func_70302_i_(); ++s) {
            ItemStack stack = inv.func_70301_a(s);
            if (stack.func_190926_b()) continue;
            if (stackIn.func_190926_b()) {
                stackIn = stack;
                continue;
            }
            return StackUtil.EMPTY;
        }
        if (stackIn.func_77973_b() != BCSiliconItems.plugFacade) {
            return StackUtil.EMPTY;
        }
        FacadeInstance states = ItemPluggableFacade.getStates(stackIn);
        states = states.withSwappedIsHollow();
        return BCSiliconItems.plugFacade.createItemStack(states);
    }

    public ItemStack func_77571_b() {
        return StackUtil.EMPTY;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public ChangingItemStack[] getRecipeInputs() {
        if (INPUTS[0] == null) {
            FacadeSwapRecipe.genRecipes();
        }
        return INPUTS;
    }

    public ChangingItemStack getRecipeOutputs() {
        if (OUTPUTS == null) {
            FacadeSwapRecipe.genRecipes();
        }
        return OUTPUTS;
    }

    private static ItemStack createFacade(FacadeBlockStateInfo info, boolean isHollow) {
        FacadeInstance state = FacadeInstance.createSingle(info, isHollow);
        return BCSiliconItems.plugFacade.createItemStack(state);
    }

    public int getRecipeWidth() {
        return 1;
    }

    public int getRecipeHeight() {
        return 1;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        return this;
    }

    public ResourceLocation getRegistryName() {
        return new ResourceLocation("buildcrafttransport", "facade_swap");
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 1 && height >= 1;
    }

    static {
        INPUTS = new ChangingItemStack[]{null};
    }
}

