/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gate;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.ITrigger;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.StatementType;
import buildcraft.lib.statement.TriggerWrapper;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TriggerType
extends StatementType<TriggerWrapper> {
    public static final TriggerType INSTANCE = new TriggerType();

    private TriggerType() {
        super(TriggerWrapper.class, null);
    }

    public TriggerWrapper convertToType(Object value) {
        if (value instanceof ITriggerInternal) {
            return new TriggerWrapper.TriggerWrapperInternal((ITriggerInternal)value);
        }
        return null;
    }

    public TriggerWrapper readFromNbt(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        String kind = nbt.func_74779_i("kind");
        if (kind == null || kind.isEmpty()) {
            return null;
        }
        EnumPipePart side = EnumPipePart.fromMeta((int)nbt.func_74771_c("side"));
        IStatement statement = (IStatement)StatementManager.statements.get(kind);
        if (statement instanceof ITrigger) {
            return TriggerWrapper.wrap((IStatement)statement, (EnumFacing)side.face);
        }
        BCLog.logger.warn("[gate.trigger] Couldn't find a trigger called '{}'! (found {})", (Object)kind, (Object)statement);
        return null;
    }

    public NBTTagCompound writeToNbt(TriggerWrapper slot) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (slot == null) {
            return nbt;
        }
        nbt.func_74778_a("kind", slot.getUniqueTag());
        nbt.func_74774_a("side", (byte)slot.sourcePart.getIndex());
        return nbt;
    }

    public TriggerWrapper readFromBuffer(PacketBufferBC buffer) throws IOException {
        if (buffer.readBoolean()) {
            String name = buffer.readString();
            EnumPipePart part = (EnumPipePart)buffer.func_179257_a(EnumPipePart.class);
            IStatement statement = (IStatement)StatementManager.statements.get(name);
            if (statement instanceof ITrigger) {
                return TriggerWrapper.wrap((IStatement)statement, (EnumFacing)part.face);
            }
            throw new InvalidInputDataException("Unknown trigger '" + name + "'");
        }
        return null;
    }

    public void writeToBuffer(PacketBufferBC buffer, TriggerWrapper slot) {
        if (slot == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_180714_a(slot.getUniqueTag());
            buffer.writeEnumValue((Enum)slot.sourcePart);
        }
    }
}

