/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.silicon.BCSiliconGuis;
import buildcraft.silicon.BCSiliconModels;
import buildcraft.silicon.BCSiliconSprites;
import buildcraft.silicon.container.ContainerAdvancedCraftingTable;
import buildcraft.silicon.container.ContainerAssemblyTable;
import buildcraft.silicon.container.ContainerGate;
import buildcraft.silicon.container.ContainerIntegrationTable;
import buildcraft.silicon.gui.GuiAdvancedCraftingTable;
import buildcraft.silicon.gui.GuiAssemblyTable;
import buildcraft.silicon.gui.GuiGate;
import buildcraft.silicon.gui.GuiIntegrationTable;
import buildcraft.silicon.plug.PluggableGate;
import buildcraft.silicon.tile.TileAdvancedCraftingTable;
import buildcraft.silicon.tile.TileAssemblyTable;
import buildcraft.silicon.tile.TileIntegrationTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCSiliconProxy
implements IGuiHandler {
    @SidedProxy(modId="buildcraftsilicon")
    private static BCSiliconProxy proxy;

    public static BCSiliconProxy getProxy() {
        return proxy;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        int data = id >>> 8;
        if ((id &= 0xFF) == BCSiliconGuis.ASSEMBLY_TABLE.ordinal() && tile instanceof TileAssemblyTable) {
            TileAssemblyTable assemblyTable = (TileAssemblyTable)tile;
            return new ContainerAssemblyTable(player, assemblyTable);
        }
        if (id == BCSiliconGuis.ADVANCED_CRAFTING_TABLE.ordinal() && tile instanceof TileAdvancedCraftingTable) {
            TileAdvancedCraftingTable advancedCraftingTable = (TileAdvancedCraftingTable)tile;
            return new ContainerAdvancedCraftingTable(player, advancedCraftingTable);
        }
        if (id == BCSiliconGuis.INTEGRATION_TABLE.ordinal() && tile instanceof TileIntegrationTable) {
            TileIntegrationTable integrationTable = (TileIntegrationTable)tile;
            return new ContainerIntegrationTable(player, integrationTable);
        }
        if (id == BCSiliconGuis.GATE.ordinal()) {
            IPipeHolder holder;
            PipePluggable plug;
            EnumFacing gateSide = EnumFacing.func_82600_a((int)data);
            if (tile instanceof IPipeHolder && (plug = (holder = (IPipeHolder)tile).getPluggable(gateSide)) instanceof PluggableGate) {
                return new ContainerGate(player, ((PluggableGate)plug).logic);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void fmlPreInit() {
    }

    public void fmlInit() {
    }

    public void fmlPostInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCSiliconProxy {
        @Override
        public void fmlPreInit() {
            super.fmlPreInit();
            BCSiliconSprites.fmlPreInit();
            BCSiliconModels.fmlPreInit();
        }

        @Override
        public void fmlInit() {
            super.fmlInit();
            BCSiliconModels.fmlInit();
        }

        @Override
        public void fmlPostInit() {
            super.fmlPostInit();
            BCSiliconModels.fmlPostInit();
        }

        @Override
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            int data = id >>> 8;
            if ((id &= 0xFF) == BCSiliconGuis.ASSEMBLY_TABLE.ordinal() && tile instanceof TileAssemblyTable) {
                TileAssemblyTable assemblyTable = (TileAssemblyTable)tile;
                return new GuiAssemblyTable(new ContainerAssemblyTable(player, assemblyTable));
            }
            if (id == BCSiliconGuis.ADVANCED_CRAFTING_TABLE.ordinal() && tile instanceof TileAdvancedCraftingTable) {
                TileAdvancedCraftingTable advancedCraftingTable = (TileAdvancedCraftingTable)tile;
                return new GuiAdvancedCraftingTable(new ContainerAdvancedCraftingTable(player, advancedCraftingTable));
            }
            if (id == BCSiliconGuis.INTEGRATION_TABLE.ordinal() && tile instanceof TileIntegrationTable) {
                TileIntegrationTable integrationTable = (TileIntegrationTable)tile;
                return new GuiIntegrationTable(new ContainerIntegrationTable(player, integrationTable));
            }
            if (id == BCSiliconGuis.GATE.ordinal()) {
                IPipeHolder holder;
                PipePluggable plug;
                EnumFacing gateSide = EnumFacing.func_82600_a((int)data);
                if (tile instanceof IPipeHolder && (plug = (holder = (IPipeHolder)tile).getPluggable(gateSide)) instanceof PluggableGate) {
                    return new GuiGate(new ContainerGate(player, ((PluggableGate)plug).logic));
                }
            }
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCSiliconProxy {
    }
}

