/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.ritual;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.biome.IDarklandsBiome;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.ritual.EnumRitualParticle;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.common.blocks.BlockACBrick;
import com.shinoow.abyssalcraft.common.blocks.BlockRitualAltar;
import com.shinoow.abyssalcraft.common.util.BiomeUtil;
import com.shinoow.abyssalcraft.init.BlockHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.util.ScheduledProcess;
import com.shinoow.abyssalcraft.lib.util.Scheduler;
import com.shinoow.abyssalcraft.lib.util.SpecialTextUtil;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class NecronomiconCleansingRitual
extends NecronomiconRitual {
    public NecronomiconCleansingRitual() {
        super("cleansing", 4, 0, 100000.0f, true, new Object[]{new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE)});
        this.setRitualParticle(EnumRitualParticle.PE_STREAM);
    }

    @Override
    public boolean canCompleteRitual(World world, BlockPos pos, EntityPlayer player) {
        for (int x = pos.func_177958_n() - 24; x < pos.func_177958_n() + 25; ++x) {
            for (int z = pos.func_177952_p() - 24; z < pos.func_177952_p() + 25; ++z) {
                BlockPos pos1 = new BlockPos(x, 0, z);
                if (!(world.func_180494_b(pos1) instanceof IDarklandsBiome)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completeRitualClient(World world, BlockPos pos, EntityPlayer player) {
        SpecialTextUtil.JzaharText("Undoing my malice on your " + TextFormatting.ITALIC + "beloved" + TextFormatting.RESET + " world? What a shame.");
    }

    @Override
    protected void completeRitualServer(final World world, BlockPos pos, EntityPlayer player) {
        int num = 1;
        int num2 = 0;
        int range = ACConfig.cleansingRitualRange * 8;
        for (int x = pos.func_177958_n() - range; x < pos.func_177958_n() + range + 1; ++x) {
            for (int z = pos.func_177952_p() - range; z < pos.func_177952_p() + range + 1; ++z) {
                final BlockPos pos1 = new BlockPos(x, 0, z);
                if (!(world.func_180494_b(pos1) instanceof IDarklandsBiome)) continue;
                Scheduler.schedule(new ScheduledProcess(num * 2){

                    @Override
                    public void execute() {
                        Biome b = NecronomiconCleansingRitual.this.getRealBiome(world.func_180494_b(pos1));
                        for (int y = 0; y < 256; ++y) {
                            if (world.func_175623_d(pos1.func_177981_b(y))) continue;
                            IBlockState state = world.func_180495_p(pos1.func_177981_b(y));
                            if (state == ACBlocks.stone.func_176223_P()) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150348_b.func_176223_P(), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darklands_oak_leaves) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).func_177226_a((IProperty)BlockLeaves.field_176237_a, state.func_177229_b((IProperty)BlockLeaves.field_176237_a)), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darklands_oak_wood || state.func_177230_c() == ACBlocks.darklands_oak_wood_2) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.abyssalnite_ore) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150366_p.func_176223_P(), 2);
                                continue;
                            }
                            if (state == ACBlocks.cobblestone.func_176223_P()) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_brick) {
                                switch ((BlockACBrick.EnumBrickType)((Object)state.func_177229_b(BlockACBrick.TYPE))) {
                                    case CHISELED: {
                                        world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED), 2);
                                        break;
                                    }
                                    case CRACKED: {
                                        world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), 2);
                                        break;
                                    }
                                    default: {
                                        world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150417_aV.func_176223_P(), 2);
                                        break;
                                    }
                                }
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_cobblestone_wall) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150463_bK.func_176223_P(), 2);
                                continue;
                            }
                            if (state == ACBlocks.ritual_altar.func_176223_P().func_177226_a(BlockRitualAltar.MATERIAL, (Comparable)((Object)BlockRitualAltar.EnumRitualMatType.DARKSTONE_COBBLESTONE))) {
                                world.func_180501_a(pos1.func_177981_b(y), ACBlocks.ritual_altar.func_176223_P(), 2);
                                continue;
                            }
                            if (state == ACBlocks.ritual_pedestal.func_176223_P().func_177226_a(BlockRitualAltar.MATERIAL, (Comparable)((Object)BlockRitualAltar.EnumRitualMatType.DARKSTONE_COBBLESTONE))) {
                                world.func_180501_a(pos1.func_177981_b(y), ACBlocks.ritual_pedestal.func_176223_P(), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_brick_slab) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)).func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_cobblestone_slab) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)).func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_slab) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 2);
                                continue;
                            }
                            if (state.func_177230_c() == BlockHandler.Darkstoneslab2) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150334_T.func_176223_P(), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.glowing_darkstone_bricks) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_brick_stairs) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darkstone_cobblestone_stairs) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darklands_oak_planks) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150344_f.func_176223_P(), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darklands_oak_stairs) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)), 2);
                                continue;
                            }
                            if (state.func_177230_c() == ACBlocks.darklands_oak_slab) {
                                world.func_180501_a(pos1.func_177981_b(y), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 2);
                                continue;
                            }
                            if (state.func_177230_c() != ACBlocks.darklands_oak_fence) continue;
                            world.func_180501_a(pos1.func_177981_b(y), Blocks.field_180407_aO.func_176223_P(), 2);
                        }
                        BiomeUtil.updateBiome(world, pos1, b, true);
                    }
                });
                if (++num2 % 256 != 0) continue;
                ++num;
            }
        }
    }

    private Biome getRealBiome(Biome b) {
        if (b == ACBiomes.darklands) {
            return Biomes.field_76772_c;
        }
        if (b == ACBiomes.darklands_plains) {
            return Biomes.field_76772_c;
        }
        if (b == ACBiomes.darklands_forest) {
            return Biomes.field_76767_f;
        }
        if (b == ACBiomes.darklands_hills) {
            return Biomes.field_76770_e;
        }
        if (b == ACBiomes.darklands_mountains) {
            return Biomes.field_76775_o;
        }
        return Biomes.field_76772_c;
    }
}

