/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity.demon;

import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonAnimal;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonSheep;
import com.shinoow.abyssalcraft.common.entity.demon.EntityEvilAnimal;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.network.client.EvilSheepMessage;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEvilSheep
extends EntityEvilAnimal {
    private UUID playerUUID = null;
    private String playerName = null;
    private int sheepTimer;
    private EntityAIEatGrass entityAIEatGrass = new EntityAIEatGrass((EntityLiving)this);

    public EntityEvilSheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.3f);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.func_151499_f();
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        }
    }

    public String func_70005_c_() {
        return I18n.func_74838_a((String)"entity.Sheep.name");
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A / 57.295776f;
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("PlayerUUID")) {
            this.playerUUID = UUID.fromString(nbttagcompound.func_74779_i("PlayerUUID"));
        }
        if (nbttagcompound.func_74764_b("PlayerName")) {
            this.playerName = nbttagcompound.func_74779_i("PlayerName");
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.playerUUID != null) {
            nbttagcompound.func_74778_a("PlayerUUID", this.playerUUID.toString());
        }
        if (this.playerName != null && this.playerName.length() > 0) {
            nbttagcompound.func_74778_a("PlayerName", this.playerName);
        }
    }

    public UUID getKilledPlayerUUID() {
        return this.playerUUID;
    }

    public String getKilledPlayerName() {
        return this.playerName;
    }

    public void setKilledPlayer(EntityPlayer player) {
        this.playerUUID = player.func_110124_au();
        this.playerName = player.func_70005_c_();
    }

    @SideOnly(value=Side.CLIENT)
    public void setKilledPlayer(UUID uuid, String name) {
        this.playerUUID = uuid;
        this.playerName = name;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        if (this.field_70173_aa % 20 == 0 && this.playerUUID != null && this.playerName != null && this.playerName.length() > 0 && !this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToDimension(new EvilSheepMessage(this.playerUUID, this.playerName, this.func_145782_y()), this.field_70170_p.field_73011_w.getDimension());
        }
        super.func_70636_d();
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_EVIL_SHEEP;
    }

    @Override
    public EntityDemonAnimal getDemonAnimal() {
        return new EntityDemonSheep(this.field_70170_p);
    }

    @Override
    public ItemStack getShearingDrop() {
        return new ItemStack(this.playerUUID != null && this.playerName != null ? Items.field_151078_bh : Item.func_150898_a((Block)Blocks.field_150325_L));
    }
}

