/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.google.common.collect.ImmutableList;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.IEnergyTransporterItem;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionEntry;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionHandler;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.event.ACEvents;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapability;
import com.shinoow.abyssalcraft.api.ritual.EnumRitualParticle;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.common.items.ItemNecronomicon;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.network.client.RitualMessage;
import com.shinoow.abyssalcraft.common.network.client.RitualStartMessage;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACSounds;
import com.shinoow.abyssalcraft.lib.util.ScheduledProcess;
import com.shinoow.abyssalcraft.lib.util.Scheduler;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualAltar;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualPedestal;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityRitualAltar
extends TileEntity
implements ITickable,
IRitualAltar {
    private int ritualTimer;
    private NecronomiconRitual ritual;
    private ItemStack item = ItemStack.field_190927_a;
    private EntityPlayer user;
    private float consumedEnergy;
    private boolean isDirty;
    private EntityLiving sacrifice;
    private List<IRitualPedestal> pedestals = new ArrayList<IRitualPedestal>();

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagCompound nbtItem = nbttagcompound.func_74775_l("Item");
        this.item = new ItemStack(nbtItem);
        this.ritualTimer = nbttagcompound.func_74762_e("Cooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (!this.item.func_190926_b()) {
            this.item.func_77955_b(nbtItem);
        }
        nbttagcompound.func_74782_a("Item", (NBTBase)nbtItem);
        nbttagcompound.func_74768_a("Cooldown", this.ritualTimer);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        if (this.isDirty || this.isPerformingRitual()) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.isDirty = false;
        }
        if (this.isPerformingRitual()) {
            if (this.ritualTimer == 1 && !this.field_145850_b.field_72995_K) {
                SoundEvent chant = this.getRandomChant();
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), chant, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), chant, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), chant, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.ritual != null && this.sacrifice != null && this.sacrifice.func_70089_S()) {
                    this.sacrifice.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 200, 0, false, false));
                }
            }
            ++this.ritualTimer;
            if (this.ritual != null) {
                if (!this.field_145850_b.field_72995_K && this.ritualTimer % 20 == 0) {
                    if (this.user != null) {
                        this.collectPEFromPlayer();
                    } else {
                        this.user = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0, true);
                    }
                }
                if (this.ritualTimer == 200) {
                    if (this.user != null && !this.field_145850_b.field_72995_K) {
                        if (!MinecraftForge.EVENT_BUS.post((Event)new ACEvents.RitualEvent.Post(this.user, this.ritual, this.field_145850_b, this.field_174879_c))) {
                            this.consumedEnergy = BigDecimal.valueOf(this.consumedEnergy).setScale(1, 4).floatValue();
                            if (!(this.consumedEnergy != this.ritual.getReqEnergy() || this.sacrifice != null && this.sacrifice.func_70089_S())) {
                                this.ritual.completeRitual(this.field_145850_b, this.field_174879_c, this.user);
                            } else {
                                this.triggerDisruption();
                            }
                            this.reset();
                        } else {
                            this.reset();
                        }
                    } else {
                        if (!this.field_145850_b.field_72995_K) {
                            this.triggerDisruption();
                        }
                        this.reset();
                    }
                }
            } else {
                this.ritualTimer = 0;
            }
            this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void reset() {
        this.ritualTimer = 0;
        this.user = null;
        this.ritual = null;
        this.consumedEnergy = 0.0f;
        this.isDirty = true;
        this.sacrifice = null;
    }

    private void collectPEFromPlayer() {
        ItemStack stack = this.user.func_184586_b(EnumHand.OFF_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IEnergyTransporterItem && ((IEnergyTransporterItem)stack.func_77973_b()).canTransferPEExternally(stack) && ((IEnergyTransporterItem)stack.func_77973_b()).getContainedEnergy(stack) > 0.0f && (stack.func_77973_b() instanceof ItemNecronomicon && ((ItemNecronomicon)stack.func_77973_b()).isOwner(this.user, stack) || !(stack.func_77973_b() instanceof ItemNecronomicon))) {
            this.consumedEnergy += ((IEnergyTransporterItem)stack.func_77973_b()).consumeEnergy(stack, this.ritual.getReqEnergy() / 10.0f);
        } else {
            for (ItemStack stack1 : this.user.field_71071_by.field_70462_a) {
                if (stack1.func_190926_b() || !(stack1.func_77973_b() instanceof IEnergyTransporterItem) || !((IEnergyTransporterItem)stack1.func_77973_b()).canTransferPEExternally(stack1) || !(((IEnergyTransporterItem)stack1.func_77973_b()).getContainedEnergy(stack1) > 0.0f) || (!(stack1.func_77973_b() instanceof ItemNecronomicon) || !((ItemNecronomicon)stack1.func_77973_b()).isOwner(this.user, stack1)) && stack1.func_77973_b() instanceof ItemNecronomicon) continue;
                this.consumedEnergy += ((IEnergyTransporterItem)stack1.func_77973_b()).consumeEnergy(stack1, this.ritual.getReqEnergy() / 10.0f);
                break;
            }
        }
    }

    private void triggerDisruption() {
        this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), true));
        EnergyEnum.DeityType deity = EnergyEnum.DeityType.values()[this.field_145850_b.field_73012_v.nextInt(EnergyEnum.DeityType.values().length)];
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(16.0, 16.0, 16.0));
        if (this.user != null) {
            ACEvents.RitualEvent.Failed event = new ACEvents.RitualEvent.Failed(this.user, this.ritual, DisruptionHandler.instance().getRandomDisruption(deity, this.field_145850_b), this.field_145850_b, this.field_174879_c);
            if (!MinecraftForge.EVENT_BUS.post((Event)event) && !ACConfig.no_disruptions) {
                DisruptionEntry disruption = event.getDisruption();
                PacketDispatcher.sendToAllAround(new RitualMessage(this.ritual.getUnlocalizedName().substring("ac.ritual.".length()), this.field_174879_c, true, disruption.getUnlocalizedName()), this.user, 5.0);
                if (!MinecraftForge.EVENT_BUS.post((Event)new ACEvents.DisruptionEvent(deity, this.field_145850_b, this.field_174879_c, players, disruption))) {
                    disruption.disrupt(this.field_145850_b, this.field_174879_c, players);
                }
                AbyssalCraftAPI.getInternalMethodHandler().sendDisruption(deity, disruption.getUnlocalizedName().substring("ac.disruption.".length()), this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
            } else if (!ACConfig.no_disruptions) {
                DisruptionHandler.instance().generateDisruption(deity, this.field_145850_b, this.field_174879_c, players);
            }
        } else if (!ACConfig.no_disruptions) {
            DisruptionHandler.instance().generateDisruption(deity, this.field_145850_b, this.field_174879_c, players);
        }
    }

    @Override
    public boolean canPerform() {
        if (this.pedestals.isEmpty()) {
            for (IRitualPedestal ped : this.getPedestals(this.field_145850_b, this.field_174879_c)) {
                ped.setAltar(this.field_174879_c);
            }
        }
        return this.pedestals.size() == 8 && this.pedestals.stream().anyMatch(p -> !p.getItem().func_190926_b());
    }

    private List<IRitualPedestal> getPedestals(World world, BlockPos pos) {
        TileEntity ped1 = world.func_175625_s(pos.func_177985_f(3));
        TileEntity ped2 = world.func_175625_s(pos.func_177964_d(3));
        TileEntity ped3 = world.func_175625_s(pos.func_177965_g(3));
        TileEntity ped4 = world.func_175625_s(pos.func_177970_e(3));
        TileEntity ped5 = world.func_175625_s(pos.func_177985_f(2).func_177970_e(2));
        TileEntity ped6 = world.func_175625_s(pos.func_177985_f(2).func_177964_d(2));
        TileEntity ped7 = world.func_175625_s(pos.func_177965_g(2).func_177970_e(2));
        TileEntity ped8 = world.func_175625_s(pos.func_177965_g(2).func_177964_d(2));
        if (ped1 instanceof IRitualPedestal && ped2 instanceof IRitualPedestal && ped3 instanceof IRitualPedestal && ped4 instanceof IRitualPedestal && ped5 instanceof IRitualPedestal && ped6 instanceof IRitualPedestal && ped7 instanceof IRitualPedestal && ped8 instanceof IRitualPedestal) {
            return ImmutableList.of((Object)((IRitualPedestal)ped1), (Object)((IRitualPedestal)ped2), (Object)((IRitualPedestal)ped3), (Object)((IRitualPedestal)ped4), (Object)((IRitualPedestal)ped5), (Object)((IRitualPedestal)ped6), (Object)((IRitualPedestal)ped7), (Object)((IRitualPedestal)ped8));
        }
        return new ArrayList<IRitualPedestal>();
    }

    @Override
    public void performRitual(final World world, final BlockPos pos, final EntityPlayer player) {
        if (world.field_72995_K || this.isPerformingRitual()) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemNecronomicon && ((ItemNecronomicon)stack.func_77973_b()).isOwner(player, stack) && RitualRegistry.instance().canPerformAction(world.field_73011_w.getDimension(), ((ItemNecronomicon)stack.func_77973_b()).getBookType()) && this.canPerform()) {
            this.ritual = RitualRegistry.instance().getRitual(world.field_73011_w.getDimension(), ((ItemNecronomicon)stack.func_77973_b()).getBookType(), (ItemStack[])this.pedestals.stream().map(p -> p.getItem()).toArray(ItemStack[]::new), this.item);
            if (this.ritual != null && NecroDataCapability.getCap(player).isUnlocked(this.ritual.getUnlockCondition(), player)) {
                if (this.ritual.requiresSacrifice()) {
                    if (!world.func_72872_a(EntityLiving.class, new AxisAlignedBB(pos).func_72314_b(4.0, 4.0, 4.0)).isEmpty()) {
                        for (final EntityLiving mob : world.func_72872_a(EntityLiving.class, new AxisAlignedBB(pos).func_72314_b(4.0, 4.0, 4.0))) {
                            if (!this.canBeSacrificed(mob) || !this.ritual.canCompleteRitual(world, pos, player) || MinecraftForge.EVENT_BUS.post((Event)new ACEvents.RitualEvent.Pre(player, this.ritual, world, pos))) continue;
                            this.pedestals.stream().forEach(IRitualPedestal::consumeItem);
                            Scheduler.schedule(new ScheduledProcess(0){

                                @Override
                                public void execute() {
                                    TileEntityRitualAltar.this.sacrifice = mob;
                                    TileEntityRitualAltar.this.ritualTimer = 1;
                                    TileEntityRitualAltar.this.user = player;
                                    TileEntityRitualAltar.this.consumedEnergy = 0.0f;
                                    TileEntityRitualAltar.this.isDirty = true;
                                    PacketDispatcher.sendToAllAround(new RitualStartMessage(pos, TileEntityRitualAltar.this.ritual.getUnlocalizedName(), TileEntityRitualAltar.this.sacrifice.func_145782_y()), world.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 30.0);
                                }
                            });
                            return;
                        }
                    }
                } else if (this.ritual.canCompleteRitual(world, pos, player) && !MinecraftForge.EVENT_BUS.post((Event)new ACEvents.RitualEvent.Pre(player, this.ritual, world, pos))) {
                    this.pedestals.stream().forEach(IRitualPedestal::consumeItem);
                    Scheduler.schedule(new ScheduledProcess(0){

                        @Override
                        public void execute() {
                            TileEntityRitualAltar.this.ritualTimer = 1;
                            TileEntityRitualAltar.this.user = player;
                            TileEntityRitualAltar.this.consumedEnergy = 0.0f;
                            TileEntityRitualAltar.this.isDirty = true;
                            PacketDispatcher.sendToAllAround(new RitualStartMessage(pos, TileEntityRitualAltar.this.ritual.getUnlocalizedName(), 0), world.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 30.0);
                        }
                    });
                }
            }
        }
    }

    private boolean canBeSacrificed(EntityLiving entity) {
        return (EntityUtil.isShoggothFood((EntityLivingBase)entity) || entity instanceof EntityVillager) && entity.func_70668_bt() != EnumCreatureAttribute.UNDEAD && entity.func_70089_S() && !entity.func_70631_g_();
    }

    public SoundEvent getRandomChant() {
        SoundEvent[] chants = new SoundEvent[]{ACSounds.cthulhu_chant, ACSounds.yog_sothoth_chant_1, ACSounds.yog_sothoth_chant_2, ACSounds.hastur_chant_1, ACSounds.hastur_chant_2, ACSounds.sleeping_chant, ACSounds.cthugha_chant};
        return chants[this.field_145850_b.field_73012_v.nextInt(chants.length)];
    }

    @Override
    public int getRitualCooldown() {
        return this.ritualTimer;
    }

    @Override
    public boolean isPerformingRitual() {
        return this.ritualTimer < 200 && this.ritualTimer > 0;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = item;
        this.isDirty = true;
    }

    @Override
    public void setRitualFields(NecronomiconRitual ritual, EntityLiving sacrifice) {
        this.ritual = ritual;
        this.sacrifice = sacrifice;
        this.ritualTimer = 1;
    }

    @Override
    public void addPedestal(IRitualPedestal pedestal) {
        this.pedestals.add(pedestal);
    }

    @Override
    public List<IRitualPedestal> getPedestals() {
        return this.pedestals;
    }

    @Override
    public EnumRitualParticle getRitualParticle() {
        return this.ritual != null ? this.ritual.getRitualParticle() : EnumRitualParticle.NONE;
    }
}

