/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.oredict.OreDictionary;

public class BlockCLiquid
extends BlockFluidClassic {
    private List<IBlockState> dusts = new ArrayList<IBlockState>();
    private List<IBlockState> metalloids = new ArrayList<IBlockState>();
    private List<IBlockState> gems = new ArrayList<IBlockState>();
    private List<IBlockState> stones = new ArrayList<IBlockState>();
    private List<IBlockState> bricks = new ArrayList<IBlockState>();
    private List<IBlockState> metals = new ArrayList<IBlockState>();
    private List<IBlockState> cobble = new ArrayList<IBlockState>();

    public BlockCLiquid() {
        super(AbyssalCraftAPI.liquid_coralium_fluid, Material.field_151586_h);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess p_180659_2_, BlockPos p_180659_3_) {
        return MapColor.field_151674_s;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world instanceof World && BiomeDictionary.hasType((Biome)((World)world).func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !ACConfig.destroyOcean && world.func_180495_p(pos).func_177230_c() == Blocks.field_150347_e) {
            return false;
        }
        if (world.func_180495_p(pos).func_185904_a().func_76224_d() && world.func_180495_p(pos).func_177230_c() != this && world.func_180495_p(pos).func_177230_c() != ACBlocks.liquid_antimatter) {
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return true;
        }
        if (this.dusts.contains(world.func_180495_p(pos)) || this.metalloids.contains(world.func_180495_p(pos)) || this.gems.contains(world.func_180495_p(pos)) || this.stones.contains(world.func_180495_p(pos)) || this.bricks.contains(world.func_180495_p(pos)) || this.cobble.contains(world.func_180495_p(pos))) {
            return true;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (!world.field_72995_K && (ACConfig.shouldSpread || world.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id)) {
            if (world.func_180495_p(pos).func_185904_a().func_76224_d() && world.func_180495_p(pos).func_177230_c() != this && world.func_180495_p(pos).func_177230_c() != ACBlocks.liquid_antimatter) {
                world.func_175656_a(pos, this.func_176223_P());
            }
            if (ACConfig.breakLogic && world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_185904_a().func_76224_d() && world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c() != this && world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c() != ACBlocks.liquid_antimatter) {
                world.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), this.func_176223_P());
            }
            if (this.dusts.contains(world.func_180495_p(pos)) && world.func_180495_p(pos) != ACBlocks.abyssal_nitre_ore.func_176223_P() && world.func_180495_p(pos) != ACBlocks.abyssal_coralium_ore) {
                if (this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreSaltpeter")).contains(world.func_180495_p(pos))) {
                    world.func_175656_a(pos, ACBlocks.abyssal_nitre_ore.func_176223_P());
                } else {
                    world.func_175656_a(pos, ACBlocks.abyssal_coralium_ore.func_176223_P());
                }
            } else if (this.metalloids.contains(world.func_180495_p(pos)) && !this.metals.contains(world.func_180495_p(pos))) {
                if (this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreIron")).contains(world.func_180495_p(pos))) {
                    world.func_175656_a(pos, ACBlocks.abyssal_iron_ore.func_176223_P());
                } else if (this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreGold")).contains(world.func_180495_p(pos))) {
                    world.func_175656_a(pos, ACBlocks.abyssal_gold_ore.func_176223_P());
                } else if (this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreTin")).contains(world.func_180495_p(pos))) {
                    world.func_175656_a(pos, ACBlocks.abyssal_tin_ore.func_176223_P());
                } else if (this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreCopper")).contains(world.func_180495_p(pos))) {
                    world.func_175656_a(pos, ACBlocks.abyssal_copper_ore.func_176223_P());
                } else {
                    world.func_175656_a(pos, ACBlocks.liquified_coralium_ore.func_176223_P());
                }
            } else if (this.gems.contains(world.func_180495_p(pos)) && world.func_180495_p(pos) != ACBlocks.abyssal_diamond_ore.func_176223_P()) {
                if (this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreDiamond")).contains(world.func_180495_p(pos))) {
                    world.func_175656_a(pos, ACBlocks.abyssal_diamond_ore.func_176223_P());
                } else {
                    world.func_175656_a(pos, ACBlocks.pearlescent_coralium_ore.func_176223_P());
                }
            } else if (this.stones.contains(world.func_180495_p(pos))) {
                world.func_175656_a(pos, ACBlocks.stone.func_176203_a(1));
            } else if (this.bricks.contains(world.func_180495_p(pos))) {
                world.func_175656_a(pos, ACBlocks.abyssal_stone_brick.func_176223_P());
            } else if (this.cobble.contains(world.func_180495_p(pos))) {
                if (BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !ACConfig.destroyOcean) {
                    if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150347_e) {
                        world.func_175656_a(pos, ACBlocks.cobblestone.func_176203_a(1));
                    }
                } else {
                    world.func_175656_a(pos, ACBlocks.cobblestone.func_176203_a(1));
                }
            }
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !ACConfig.destroyOcean) {
            world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
        }
        super.func_176213_c(world, pos, state);
    }

    public void func_180634_a(World par1World, BlockPos pos, IBlockState state, Entity par5Entity) {
        super.func_180634_a(par1World, pos, state, par5Entity);
        if (par5Entity instanceof EntityLivingBase && !EntityUtil.isEntityCoralium((EntityLivingBase)par5Entity) && ((EntityLivingBase)par5Entity).func_70660_b(AbyssalCraftAPI.coralium_plague) == null) {
            ((EntityLivingBase)par5Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 200));
        }
    }

    private List<IBlockState> oresToBlocks(List<ItemStack> list) {
        ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
        for (ItemStack stack : list) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == null || block == Blocks.field_150350_a) continue;
            try {
                blocks.add(block.func_176203_a(((ItemBlock)stack.func_77973_b()).func_77647_b(stack.func_77960_j() == Short.MAX_VALUE ? 0 : stack.func_77960_j())));
            }
            catch (Exception e) {
                ACLogger.severe("Unable to convert {} with meta {} into a BlockState", block.getRegistryName(), stack.func_77960_j());
            }
        }
        return blocks;
    }

    public void addBlocks() {
        this.dusts.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreSaltpeter")));
        if (!OreDictionary.getOres((String)"oreSulfur").isEmpty()) {
            this.dusts.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreSulfur")));
        }
        this.dusts.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreLapis")));
        this.dusts.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreRedstone")));
        this.dusts.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreCoal")));
        this.dusts.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreCoralium")));
        this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreIron")));
        this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreGold")));
        this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreAbyssalnite")));
        this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreDreadedAbyssalnite")));
        this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreCopper")));
        this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreTin")));
        if (!OreDictionary.getOres((String)"oreAluminum").isEmpty()) {
            this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreAluminum")));
        }
        if (!OreDictionary.getOres((String)"oreAluminium").isEmpty()) {
            this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreAluminium")));
        }
        if (!OreDictionary.getOres((String)"oreBrass").isEmpty()) {
            this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreBrass")));
        }
        if (!OreDictionary.getOres((String)"oreSilver").isEmpty()) {
            this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreSilver")));
        }
        if (!OreDictionary.getOres((String)"oreZinc").isEmpty()) {
            this.metalloids.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreZinc")));
        }
        this.gems.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreDiamond")));
        this.gems.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreEmerald")));
        this.gems.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreQuartz")));
        if (!OreDictionary.getOres((String)"oreSapphire").isEmpty()) {
            this.gems.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreSapphire")));
        }
        if (!OreDictionary.getOres((String)"oreRuby").isEmpty()) {
            this.gems.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreRuby")));
        }
        this.gems.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"oreCoraliumStone")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stone")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stoneGranite")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stoneGranitePolished")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stoneDiorite")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stoneDioritePolished")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stoneAndesite")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"stoneAndesitePolished")));
        this.stones.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"sandstone")));
        this.stones.add(Blocks.field_150424_aL.func_176223_P());
        this.stones.add(Blocks.field_150377_bs.func_176223_P());
        this.stones.add(ACBlocks.stone.func_176223_P());
        this.stones.add(ACBlocks.stone.func_176203_a(2));
        this.stones.add(ACBlocks.stone.func_176203_a(3));
        this.bricks.add(Blocks.field_150417_aV.func_176203_a(0));
        this.bricks.add(Blocks.field_150417_aV.func_176203_a(1));
        this.bricks.add(Blocks.field_150417_aV.func_176203_a(2));
        this.bricks.add(Blocks.field_150417_aV.func_176203_a(3));
        this.bricks.add(Blocks.field_150385_bj.func_176223_P());
        this.bricks.add(ACBlocks.darkstone_brick.func_176223_P());
        this.bricks.add(ACBlocks.darkstone_brick.func_176203_a(1));
        this.bricks.add(ACBlocks.darkstone_brick.func_176203_a(2));
        this.bricks.add(ACBlocks.abyssalnite_stone_brick.func_176223_P());
        this.bricks.add(ACBlocks.abyssalnite_stone_brick.func_176203_a(1));
        this.bricks.add(ACBlocks.abyssalnite_stone_brick.func_176203_a(2));
        this.bricks.add(ACBlocks.dreadstone_brick.func_176223_P());
        this.bricks.add(ACBlocks.dreadstone_brick.func_176203_a(1));
        this.bricks.add(ACBlocks.dreadstone_brick.func_176203_a(2));
        this.bricks.add(Blocks.field_185772_cY.func_176223_P());
        this.bricks.add(Blocks.field_189879_dh.func_176223_P());
        this.metals.add(ACBlocks.abyssal_iron_ore.func_176223_P());
        this.metals.add(ACBlocks.abyssal_gold_ore.func_176223_P());
        this.metals.add(ACBlocks.abyssal_copper_ore.func_176223_P());
        this.metals.add(ACBlocks.abyssal_tin_ore.func_176223_P());
        this.metals.add(ACBlocks.liquified_coralium_ore.func_176223_P());
        this.cobble.addAll(this.oresToBlocks((List<ItemStack>)OreDictionary.getOres((String)"cobblestone")));
        this.cobble.add(Blocks.field_150341_Y.func_176223_P());
        this.cobble.add(ACBlocks.cobblestone.func_176203_a(0));
        this.cobble.add(ACBlocks.cobblestone.func_176203_a(2));
        this.cobble.add(ACBlocks.cobblestone.func_176203_a(3));
        this.cobble.add(ACBlocks.cobblestone.func_176203_a(4));
    }
}

