/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.lib;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockRenderData
implements IBlockAccess {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    private World world;
    private IBlockState[][][] states;
    private final transient Map<BlockPos, TileEntity> teCache = new HashMap<BlockPos, TileEntity>();

    public void calculateData(IBlockState[][][] data) {
        this.sizeY = data.length;
        this.sizeX = data[0].length;
        this.sizeZ = data[0][0].length;
        this.states = new IBlockState[this.sizeY][this.sizeX][this.sizeZ];
        for (int y = 0; y < this.sizeY; ++y) {
            for (int x = 0; x < this.sizeX; ++x) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    IBlockState state = data[y][x][z];
                    this.states[y][x][z] = state == null ? Blocks.field_150350_a.func_176223_P() : state;
                }
            }
        }
    }

    public void setWorld(World world) {
        this.world = world;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        if (state.func_177230_c().hasTileEntity(state)) {
            return this.teCache.computeIfAbsent(pos.func_185334_h(), p -> state.func_177230_c().createTileEntity(this.world, state));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        return 0xF000F0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < 0 || y < 0 || z < 0 || x >= this.sizeX || y >= this.sizeY || z >= this.sizeZ) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.states[y][x][z];
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return Biomes.field_76772_c;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }
}

