/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.ritual;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RitualRegistry {
    private final Map<Integer, Integer> dimToBookType = new HashMap<Integer, Integer>();
    private final Map<Integer, String> dimToName = new HashMap<Integer, String>();
    private final Map<NecronomiconRitual, Integer> ritualToBookType = new HashMap<NecronomiconRitual, Integer>();
    private final List<NecronomiconRitual> rituals = new ArrayList<NecronomiconRitual>();
    private final Logger logger = LogManager.getLogger((String)"RitualRegistry");
    private static final RitualRegistry instance = new RitualRegistry();

    public static RitualRegistry instance() {
        return instance;
    }

    private RitualRegistry() {
    }

    public void addDimensionToBookType(int dim, int bookType) {
        if (bookType <= 4 && bookType >= 0) {
            if (dim != -1 && dim != 1) {
                this.dimToBookType.put(dim, bookType);
            } else {
                this.logger.log(Level.ERROR, "You're not allowed to register that Dimension ID: {}", (Object)dim);
            }
        } else {
            this.logger.log(Level.ERROR, "Necronomicon book type does not exist: {}", (Object)bookType);
        }
    }

    public void addDimensionToName(int dim, String name) {
        if (dim != -1 && dim != 1) {
            this.dimToName.put(dim, name);
        } else {
            this.logger.log(Level.ERROR, "You're not allowed to register that Dimension ID: {}", (Object)dim);
        }
    }

    public void addDimensionToBookTypeAndName(int dim, int bookType, String name) {
        this.addDimensionToBookType(dim, bookType);
        this.addDimensionToName(dim, name);
    }

    public boolean canPerformAction(int dim, int bookType) {
        if (!this.dimToBookType.containsKey(dim)) {
            return false;
        }
        return bookType >= this.dimToBookType.get(dim);
    }

    public boolean sameBookType(int dim, int bookType) {
        if (!this.dimToBookType.containsKey(dim)) {
            return false;
        }
        return bookType == this.dimToBookType.get(dim);
    }

    public void registerRitual(NecronomiconRitual ritual) {
        if (ritual.getBookType() <= 4 && ritual.getBookType() >= 0) {
            for (NecronomiconRitual entry : this.rituals) {
                if (!ritual.getUnlocalizedName().equals(entry.getUnlocalizedName())) continue;
                this.logger.log(Level.ERROR, "Necronomicon Ritual already registered: {}", (Object)ritual.getUnlocalizedName());
                return;
            }
            this.rituals.add(ritual);
        } else {
            this.logger.log(Level.ERROR, "Necronomicon book type does not exist: {}", (Object)ritual.getBookType());
        }
    }

    public List<NecronomiconRitual> getRituals() {
        return this.rituals;
    }

    public Map<Integer, String> getDimensionNameMappings() {
        return this.dimToName;
    }

    public NecronomiconRitual getRitual(int dimension, int bookType, ItemStack[] offerings, ItemStack sacrifice) {
        return this.rituals.stream().filter(ritual -> this.areRitualsSame((NecronomiconRitual)ritual, dimension, bookType, offerings, sacrifice)).findFirst().orElse(null);
    }

    private boolean areRitualsSame(NecronomiconRitual ritual, int dimension, int bookType, ItemStack[] offerings, ItemStack sacrifice) {
        return (ritual.getDimension() == dimension || ritual.getDimension() == -1) && ritual.getBookType() <= bookType && ritual.getOfferings() != null && offerings != null && APIUtils.areItemStackArraysEqual(ritual.getOfferings(), offerings, ritual.isNBTSensitive()) && (ritual.requiresItemSacrifice() || ritual.getSacrifice() == null && sacrifice.func_190926_b() || APIUtils.areObjectsEqual(sacrifice, ritual.getSacrifice(), ritual.isSacrificeNBTSensitive()));
    }

    @Deprecated
    public boolean areObjectsEqual(ItemStack stack, Object obj, boolean nbt) {
        return APIUtils.areObjectsEqual(stack, obj, nbt);
    }

    @Deprecated
    public boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean nbt) {
        return APIUtils.areStacksEqual(stack1, stack2, nbt);
    }

    @Deprecated
    public boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return APIUtils.areStacksEqual(stack1, stack2);
    }
}

