/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.rending;

import com.shinoow.abyssalcraft.api.rending.Rending;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendingRegistry {
    private final List<Rending> rendings = new ArrayList<Rending>();
    private final Logger logger = LogManager.getLogger((String)"RendingRegistry");
    private static final RendingRegistry instance = new RendingRegistry();

    public static RendingRegistry instance() {
        return instance;
    }

    private RendingRegistry() {
    }

    public void registerRending(Rending rending) {
        if (this.rendings.stream().anyMatch(r -> r.getName().equalsIgnoreCase(rending.getName()))) {
            this.logger.log(Level.ERROR, "Rending already registered: {}", (Object)rending.getName());
            return;
        }
        this.rendings.add(rending);
    }

    public List<Rending> getRendings() {
        return this.rendings;
    }
}

