/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.recipe;

import com.shinoow.abyssalcraft.api.APIUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrystallizerRecipes {
    private static final CrystallizerRecipes crystallizationBase = new CrystallizerRecipes();
    private final Map<ItemStack, ItemStack[]> crystallizationList = new HashMap<ItemStack, ItemStack[]>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static CrystallizerRecipes instance() {
        return crystallizationBase;
    }

    private CrystallizerRecipes() {
    }

    public void crystallize(Block input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallize(Item.func_150898_a((Block)input), output1, output2, xp);
    }

    public void crystallize(Item input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallize(new ItemStack(input, 1, Short.MAX_VALUE), output1, output2, xp);
    }

    public void crystallize(ItemStack input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallizationList.put(input, new ItemStack[]{output1, output2});
        this.experienceList.put(output1, Float.valueOf(xp));
    }

    public ItemStack[] getCrystallizationResult(ItemStack stack) {
        return this.crystallizationList.entrySet().stream().filter(e -> APIUtils.areStacksEqual(stack, (ItemStack)e.getKey())).map(e -> (ItemStack[])e.getValue()).findFirst().orElse(new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a});
    }

    public Map<ItemStack, ItemStack[]> getCrystallizationList() {
        return this.crystallizationList;
    }

    public float getExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        return this.experienceList.entrySet().stream().filter(e -> APIUtils.areStacksEqual(stack, (ItemStack)e.getKey())).map(e -> Float.valueOf(((Float)e.getValue()).floatValue())).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }
}

