/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.registry.PulleyStructureManager;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.DirUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PulleyUtil {
    public static boolean isAnchorSupported(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block topblock = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        EnumFacing facing = ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176734_d();
        IBlockState sidingblock = world.func_180495_p(pos.func_177972_a(facing));
        return topblock == BWMBlocks.ROPE || sidingblock.isSideSolid((IBlockAccess)world, pos, facing.func_176734_d()) && !PulleyStructureManager.isPulleyBlock((IBlockState)sidingblock);
    }

    public static boolean findPlatformPart(World world, BlockPos pos, HashSet<BlockPos> set) {
        if (set.size() > GlobalConfig.maxPlatformBlocks) {
            return false;
        }
        if (!PulleyUtil.isValidPlatformPart(world, pos, world.func_180495_p(pos))) {
            return true;
        }
        set.add(pos);
        ArrayList fails = new ArrayList();
        Arrays.asList(pos.func_177984_a(), pos.func_177977_b(), pos.func_177978_c(), pos.func_177968_d(), pos.func_177974_f(), pos.func_177976_e()).forEach(q -> {
            if (fails.isEmpty() && !set.contains(q) && !PulleyUtil.findPlatformPart(world, q, set)) {
                fails.add(q);
            }
        });
        return fails.isEmpty();
    }

    public static boolean findFallingPlatformPart(World world, BlockPos pos, HashSet<BlockPos> set) {
        if (set.size() > GlobalConfig.maxPlatformBlocks) {
            return false;
        }
        if (world.func_180495_p(pos).func_177230_c() == BWMBlocks.ANCHOR && PulleyUtil.isAnchorSupported(world, pos)) {
            return false;
        }
        if (!PulleyUtil.isValidPlatformPart(world, pos, world.func_180495_p(pos))) {
            return true;
        }
        BlockPos blockCheck = pos.func_177977_b();
        IBlockState stateBlocking = world.func_180495_p(blockCheck);
        if (!(world.func_175623_d(blockCheck) || stateBlocking.func_177230_c().func_176200_f((IBlockAccess)world, blockCheck) || PulleyUtil.isValidPlatformPart(world, blockCheck, stateBlocking) || set.contains(blockCheck))) {
            return false;
        }
        set.add(pos);
        ArrayList fails = new ArrayList();
        Arrays.asList(pos.func_177984_a(), pos.func_177977_b(), pos.func_177978_c(), pos.func_177968_d(), pos.func_177974_f(), pos.func_177976_e()).forEach(q -> {
            if (fails.isEmpty() && !set.contains(q) && !PulleyUtil.findFallingPlatformPart(world, q, set)) {
                fails.add(q);
            }
        });
        return fails.isEmpty();
    }

    public static boolean isValidPlatformPart(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        return PulleyStructureManager.isPulleyBlock((IBlockState)state) || block == BWMBlocks.ANCHOR && !PulleyUtil.isAnchorSupported(world, pos);
    }
}

