/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import betterwithaddons.util.NabeResultPoison;
import betterwithaddons.util.NabeResultTea;
import betterwithaddons.util.StackResult;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class NabeResult {
    public static final HashMap<String, Supplier<NabeResult>> DESERIALIZER_REGISTRY = new HashMap();
    public static final HashMap<Class<? extends NabeResult>, String> SERIALIZER_REGISTRY = new HashMap();
    public static final int MAX_FLUID_FILL = 1000;
    FluidStack fluid;
    ResourceLocation texture;
    int color;

    public static void registerResultType(Class<? extends NabeResult> clazz, String name, Supplier<NabeResult> constructor) {
        SERIALIZER_REGISTRY.put(clazz, name);
        DESERIALIZER_REGISTRY.put(name, constructor);
    }

    protected NabeResult() {
    }

    public NabeResult(FluidStack fluid) {
        this.fluid = fluid;
    }

    public NabeResult(ResourceLocation texture, int color) {
        this.texture = texture;
        this.color = color;
    }

    public ResourceLocation getTexture() {
        return this.fluid != null ? this.fluid.getFluid().getStill(this.fluid) : this.texture;
    }

    public int getColor() {
        return this.fluid != null ? this.fluid.getFluid().getColor(this.fluid) : this.color;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public float getFillRatio() {
        return this.fluid != null ? (float)this.fluid.amount / 1000.0f : 1.0f;
    }

    public boolean isFull() {
        return this.fluid != null && this.fluid.amount >= 1000;
    }

    public StackResult take(ItemStack container) {
        int amount;
        ItemStack bucket;
        IFluidHandlerItem handler;
        if (this.fluid != null && (handler = FluidUtil.getFluidHandler((ItemStack)container)) != null && (handler = FluidUtil.getFluidHandler((ItemStack)(bucket = container.func_77979_a(1)))) != null && (amount = handler.fill(this.fluid, true)) > 0) {
            this.fluid.amount -= amount;
            return new StackResult(true, container, handler.getContainer());
        }
        return new StackResult(false, container);
    }

    public final NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("type", SERIALIZER_REGISTRY.get(this.getClass()));
        this.writeToNBT(compound);
        return compound;
    }

    public static NabeResult deserializeNBT(NBTTagCompound compound) {
        if (DESERIALIZER_REGISTRY.containsKey(compound.func_74779_i("type"))) {
            NabeResult result = DESERIALIZER_REGISTRY.get(compound.func_74779_i("type")).get();
            result.readFromNBT(compound);
            return result;
        }
        return new NabeResult();
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(compound);
        } else {
            compound.func_74768_a("color", this.color);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.color = compound.func_74762_e("color");
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
    }

    public NabeResult copy() {
        NabeResult result = new NabeResult();
        result.color = this.color;
        result.fluid = this.fluid.copy();
        result.texture = this.texture;
        return result;
    }

    static {
        NabeResult.registerResultType(NabeResult.class, "fluid", NabeResult::new);
        NabeResult.registerResultType(NabeResultTea.class, "tea", NabeResultTea::new);
        NabeResult.registerResultType(NabeResultPoison.class, "poison", NabeResultPoison::new);
    }
}

